/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.tokenhistory;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import xyz.groundx.caver_ext_kas.kas.utils.KASUtils;

public class TokenHistoryQueryOptions {
    String caFilter;
    String kind;
    String range;
    Long size;
    String cursor;
    String status;
    String type;
    Boolean excludeZeroKlay;
    Boolean fromOnly;
    Boolean toOnly;

    public TokenHistoryQueryOptions() {
    }

    public TokenHistoryQueryOptions(String caFilter, String kind, String range, Long size, String cursor, String status, String type) {
        this.caFilter = caFilter;
        this.kind = kind;
        this.range = range;
        this.size = size;
        this.cursor = cursor;
        this.status = status;
        this.type = type;
    }

    public String getCaFilter() {
        return this.caFilter;
    }

    public String getKind() {
        return this.kind;
    }

    public String getRange() {
        return this.range;
    }

    public Long getSize() {
        return this.size;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getExcludeZeroKlay() {
        return this.excludeZeroKlay;
    }

    public Boolean getFromOnly() {
        return this.fromOnly;
    }

    public Boolean getToOnly() {
        return this.toOnly;
    }

    public void setCaFilter(String caFilter) {
        this.caFilter = caFilter;
    }

    public void setCaFilter(List<String> caFilters) {
        this.caFilter = KASUtils.parameterToString(caFilters);
    }

    public void setKind(KIND kind) {
        this.setKind(kind.getKind());
    }

    public void setKind(KIND[] kindArr) {
        List<String> kinds = Arrays.stream(kindArr).map(KIND::getKind).collect(Collectors.toList());
        this.setKind(kinds);
    }

    public void setKind(String kind) {
        if (!KIND.isExist(kind)) {
            throw new InvalidParameterException("The kind option must have one of the following: [" + KIND.getAllKind() + "]");
        }
        this.kind = kind;
    }

    public void setKind(List<String> kinds) {
        if (kinds.size() > KIND.values().length) {
            throw new InvalidParameterException("The 'kind' option must have up to " + KIND.values().length + "items. [" + KIND.getAllKind() + "]");
        }
        boolean isMatch = kinds.stream().anyMatch(item -> !KIND.isExist(item));
        if (isMatch) {
            throw new InvalidParameterException("The kind option must have one of the following: [" + KIND.getAllKind() + "]");
        }
        this.kind = KASUtils.parameterToString(kinds);
    }

    public void setRange(String from) {
        this.range = this.convertTime(from);
    }

    public void setRange(String from, String to) {
        String toData;
        String fromData = this.convertTime(from);
        if (!this.checkRangeValid(fromData, toData = this.convertTime(to))) {
            throw new InvalidParameterException("The range parameter('from', 'to') must have same type(block number(hex) / timestamp(decimal))");
        }
        this.range = KASUtils.parameterToString(Arrays.asList(fromData, toData));
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public void setStatus(String status) {
        if (!LABEL_STATUS.isExist(status)) {
            throw new InvalidParameterException("The status parameter have one of the following: [" + LABEL_STATUS.getAllStatus() + "]");
        }
        this.status = status;
    }

    public void setStatus(LABEL_STATUS status) {
        this.status = status.getStatus();
    }

    public void setType(String type) {
        if (!CONTRACT_TYPE.isExist(type)) {
            throw new InvalidParameterException("The type parameter have one of the following: [" + CONTRACT_TYPE.getAllType() + "]");
        }
        this.type = type;
    }

    public void setType(CONTRACT_TYPE type) {
        this.type = type.getType();
    }

    public void setExcludeZeroKlay(Boolean excludeZeroKlay) {
        this.excludeZeroKlay = excludeZeroKlay;
    }

    public void setFromOnly(Boolean fromOnly) {
        this.fromOnly = fromOnly;
    }

    public void setToOnly(Boolean toOnly) {
        this.toOnly = toOnly;
    }

    boolean checkRangeValid(String from, String to) {
        if (KASUtils.isTimeStamp(from) && KASUtils.isBlockNumber(from)) {
            return false;
        }
        if (KASUtils.isTimeStamp(from)) {
            return KASUtils.isTimeStamp(to);
        }
        return KASUtils.isBlockNumber(to);
    }

    String convertTime(String data) {
        if (KASUtils.isBlockNumber(data)) {
            return data;
        }
        return KASUtils.convertDateToTimestamp(data);
    }

    public static enum LABEL_STATUS {
        COMPLETED("completed"),
        PROCESSING("processing"),
        FAILED("failed"),
        CANCELLED("cancelled");

        String status;

        private LABEL_STATUS(String status) {
            this.status = status;
        }

        public static boolean isExist(String status) {
            for (LABEL_STATUS labelStatus : LABEL_STATUS.values()) {
                if (!labelStatus.getStatus().equals(status)) continue;
                return true;
            }
            return false;
        }

        public static String getAllStatus() {
            String result = "";
            for (int i = 0; i < LABEL_STATUS.values().length; ++i) {
                LABEL_STATUS status = LABEL_STATUS.values()[i];
                result = result + "'" + status.getStatus() + "'";
                if (i == LABEL_STATUS.values().length - 1) continue;
                result = result + ", ";
            }
            return result;
        }

        public String getStatus() {
            return this.status;
        }
    }

    public static enum KIND {
        KLAY("klay"),
        FT("ft"),
        NFT("nft"),
        MT("mt");

        String kind;

        private KIND(String kind) {
            this.kind = kind;
        }

        public static boolean isExist(String kind) {
            for (KIND kindType : KIND.values()) {
                if (!kindType.getKind().equals(kind)) continue;
                return true;
            }
            return false;
        }

        public static String getAllKind() {
            String result = "";
            for (int i = 0; i < KIND.values().length; ++i) {
                KIND kind = KIND.values()[i];
                result = result + "'" + kind.getKind() + "'";
                if (i == KIND.values().length - 1) continue;
                result = result + ", ";
            }
            return result;
        }

        public String getKind() {
            return this.kind;
        }
    }

    public static enum CONTRACT_TYPE {
        KIP7("KIP-7"),
        ERC20("ERC-20"),
        KIP17("KIP-17"),
        ERC721("ERC-721"),
        KIP37("KIP-37"),
        ERC1155("ERC-1155");

        String type;

        private CONTRACT_TYPE(String type) {
            this.type = type;
        }

        public static boolean isExist(String type) {
            for (CONTRACT_TYPE contractType : CONTRACT_TYPE.values()) {
                if (!contractType.getType().equals(type)) continue;
                return true;
            }
            return false;
        }

        public static String getAllType() {
            String result = "";
            for (int i = 0; i < CONTRACT_TYPE.values().length; ++i) {
                CONTRACT_TYPE type = CONTRACT_TYPE.values()[i];
                result = result + "'" + type.getType() + "'";
                if (i == CONTRACT_TYPE.values().length - 1) continue;
                result = result + ", ";
            }
            return result;
        }

        public String getType() {
            return this.type;
        }
    }
}

