/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.kas.tokenhistory;

import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import xyz.groundx.caver_ext_kas.kas.utils.KASUtils;

public class TokenHistoryQueryOptions {
    String caFilter;
    String kind;
    String range;
    Long size;
    String cursor;
    String status;
    String type;

    public TokenHistoryQueryOptions() {
    }

    public TokenHistoryQueryOptions(String caFilter, String kind, String range, Long size, String cursor, String status, String type) {
        this.caFilter = caFilter;
        this.kind = kind;
        this.range = range;
        this.size = size;
        this.cursor = cursor;
        this.status = status;
        this.type = type;
    }

    public String getCaFilter() {
        return this.caFilter;
    }

    public String getKind() {
        return this.kind;
    }

    public String getRange() {
        return this.range;
    }

    public Long getSize() {
        return this.size;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public void setCaFilter(String caFilter) {
        this.caFilter = caFilter;
    }

    public void setKind(String kind) {
        this.setKind(Arrays.asList(kind));
    }

    public void setKind(List<String> kinds) {
        if (kinds.size() > 3) {
            throw new InvalidParameterException("The 'kind' option must have up to 3 items. ['klay', 'ft', 'nft']");
        }
        boolean isMatch = kinds.stream().anyMatch(item -> !item.equals("klay") && !item.equals("ft") && !item.equals("nft"));
        if (isMatch) {
            throw new InvalidParameterException("The kind option must have one of the following: ['klay', 'ft', 'nft']");
        }
        this.kind = KASUtils.parameterToString(kinds);
    }

    public void setRange(String from) {
        this.range = this.convertTime(from);
    }

    public void setRange(String from, String to) {
        String toData;
        String fromData = this.convertTime(from);
        if (!this.checkRangeValid(fromData, toData = this.convertTime(to))) {
            throw new InvalidParameterException("The range parameter('from', 'to') must have same type(block number(hex) / timestamp(decimal))");
        }
        this.range = KASUtils.parameterToString(Arrays.asList(fromData, toData));
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public void setStatus(String status) {
        if (!(status.equals("completed") || status.equals("processing") || status.equals("failed") || status.equals("cancelled"))) {
            throw new InvalidParameterException("The status parameter have one of the following: [completed, processing, failed, cancelled");
        }
        this.status = status;
    }

    public void setType(String type) {
        if (type == null || type.isEmpty()) {
            type = null;
        } else if (!(type.equals("KIP-7") || type.equals("ERC-20") || type.equals("KIP-17") || type.equals("ERC-721"))) {
            throw new InvalidParameterException("The type parameter have one of the following: ['KIP-7', 'ERC-20', empty string(or null)]");
        }
        this.type = type;
    }

    boolean checkRangeValid(String from, String to) {
        if (KASUtils.isTimeStamp(from) && KASUtils.isBlockNumber(from)) {
            return false;
        }
        if (KASUtils.isTimeStamp(from)) {
            return KASUtils.isTimeStamp(to);
        }
        return KASUtils.isBlockNumber(to);
    }

    String convertTime(String data) {
        if (KASUtils.isBlockNumber(data)) {
            return data;
        }
        return KASUtils.convertDateToTimestamp(data);
    }
}

