/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Signature;

@Schema(description="Fee delegation transaction information sent to Klaytn")
public class FDTransactionResult {
    @SerializedName(value="feePayer")
    private String feePayer = null;
    @SerializedName(value="feeRatio")
    private Long feeRatio = null;
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="gas")
    private Long gas = null;
    @SerializedName(value="gasPrice")
    private String gasPrice = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="signatures")
    private List<Signature> signatures = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="typeInt")
    private Long typeInt = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="accountKey")
    private String accountKey = null;

    public FDTransactionResult feePayer(String feePayer) {
        this.feePayer = feePayer;
        return this;
    }

    @Schema(example="0x85b98485444c89880cd9c48807cef727c296f2da", required=true, description="Account address for fee delegation of transaction")
    public String getFeePayer() {
        return this.feePayer;
    }

    public void setFeePayer(String feePayer) {
        this.feePayer = feePayer;
    }

    public FDTransactionResult feeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
        return this;
    }

    @Schema(example="10", description="Ratio to be paid by the Proxy fee payer for the entire transaction fee")
    public Long getFeeRatio() {
        return this.feeRatio;
    }

    public void setFeeRatio(Long feeRatio) {
        this.feeRatio = feeRatio;
    }

    public FDTransactionResult from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x0225b5a7683ac651931c1b6123b7d197d6c24d9d", required=true, description="Klaytn account address sending a transaction")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public FDTransactionResult gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", required=true, description="Max. transaction fee (gas) for sending the transaction")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public FDTransactionResult gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Schema(example="0x5d21dba00", required=true, description="Gas price for sending the transaction")
    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public FDTransactionResult input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="0x6d656d6f", description="Data attached to and used for executing the outgoing transaction")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public FDTransactionResult nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", required=true, description="No. of current user\u2019s previous transactions")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public FDTransactionResult rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="0x12f8e3808505d21dba00830f4240942f87ba64de5526f7880f21481effbf950f70005c12940225b5a7683ac651931c1b6123b7d197d6c24d9d846d656d6f0af847f8458207f5a06edfb59009dd8d9e1ab0deb9632bd5557a1b701eaad1bccc06087772d7d10e0ea04b2032b6f7c4f716d30da650533499ff0d6e3451cb419bf19e5897678db8644a9485b98485444c89880cd9c48807cef727c296f2daf847f8458207f6a0915ef11a6411ce25ea1c0b5363c37d90eee5b131a03ddaeabf987b34a960894ea020b13b210c4ad961746d087682fc8c272adb9b5183a2d83ad74c0a9ea148d776", required=true, description="RLP serialization value of the transaction")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public FDTransactionResult signatures(List<Signature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public FDTransactionResult addSignaturesItem(Signature signaturesItem) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<Signature>();
        }
        this.signatures.add(signaturesItem);
        return this;
    }

    @Schema(description="")
    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures;
    }

    public FDTransactionResult status(String status) {
        this.status = status;
        return this;
    }

    @Schema(example="Submitted", description="Status of the transaction(\u201cSubmitted\u201d or \u201cPending\u201d)")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public FDTransactionResult to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="0x2f87ba64de5526f7880f21481effbf950f70005c", description="Klaytn account address to receive KLAY")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public FDTransactionResult transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="0xd4ebc769956b8471fb497d22f655895e675a907ca9db8a64f84998ee460e8d21", description="Transaction hash value")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public FDTransactionResult typeInt(Long typeInt) {
        this.typeInt = typeInt;
        return this;
    }

    @Schema(example="18", required=true, description="Numeric value of transaction type")
    public Long getTypeInt() {
        return this.typeInt;
    }

    public void setTypeInt(Long typeInt) {
        this.typeInt = typeInt;
    }

    public FDTransactionResult value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0x12", description="KLAY converted into PEB unit")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public FDTransactionResult transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(example="0x0416bf52b804211220aca957250d6bc2e2c6ab8688e68dc9096ae035d009c334", description="Multisig transaction ID")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public FDTransactionResult accountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    @Schema(example="0x04f84b04f848e303a102c7460ef57f8b648220667785dc6c87f132d57b8e5d8d3373e37c4c9798460eafe301a102ffb48935aa7460b0595e1fe6749c402eaa59d6fd78dd64217470191580f73211", description="Updated account key")
    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDTransactionResult fdTransactionResult = (FDTransactionResult)o;
        return Objects.equals(this.feePayer, fdTransactionResult.feePayer) && Objects.equals(this.feeRatio, fdTransactionResult.feeRatio) && Objects.equals(this.from, fdTransactionResult.from) && Objects.equals(this.gas, fdTransactionResult.gas) && Objects.equals(this.gasPrice, fdTransactionResult.gasPrice) && Objects.equals(this.input, fdTransactionResult.input) && Objects.equals(this.nonce, fdTransactionResult.nonce) && Objects.equals(this.rlp, fdTransactionResult.rlp) && Objects.equals(this.signatures, fdTransactionResult.signatures) && Objects.equals(this.status, fdTransactionResult.status) && Objects.equals(this.to, fdTransactionResult.to) && Objects.equals(this.transactionHash, fdTransactionResult.transactionHash) && Objects.equals(this.typeInt, fdTransactionResult.typeInt) && Objects.equals(this.value, fdTransactionResult.value) && Objects.equals(this.transactionId, fdTransactionResult.transactionId) && Objects.equals(this.accountKey, fdTransactionResult.accountKey);
    }

    public int hashCode() {
        return Objects.hash(this.feePayer, this.feeRatio, this.from, this.gas, this.gasPrice, this.input, this.nonce, this.rlp, this.signatures, this.status, this.to, this.transactionHash, this.typeInt, this.value, this.transactionId, this.accountKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDTransactionResult {\n");
        sb.append("    feePayer: ").append(this.toIndentedString(this.feePayer)).append("\n");
        sb.append("    feeRatio: ").append(this.toIndentedString(this.feeRatio)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    signatures: ").append(this.toIndentedString(this.signatures)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    typeInt: ").append(this.toIndentedString(this.typeInt)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    accountKey: ").append(this.toIndentedString(this.accountKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

