/*
 * Decompiled with CFR 0.152.
 */
package xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import xyz.groundx.caver_ext_kas.rest_client.io.swagger.client.api.wallet.model.Signature;

@Schema(description="Klaytn\uc5d0 \uc804\uc1a1\ub41c \ud2b8\ub79c\uc7ad\uc158 \uc815\ubcf4")
public class TransactionResult {
    @SerializedName(value="from")
    private String from = null;
    @SerializedName(value="gas")
    private Long gas = null;
    @SerializedName(value="gasPrice")
    private String gasPrice = null;
    @SerializedName(value="input")
    private String input = null;
    @SerializedName(value="nonce")
    private Long nonce = null;
    @SerializedName(value="rlp")
    private String rlp = null;
    @SerializedName(value="signatures")
    private List<Signature> signatures = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="to")
    private String to = null;
    @SerializedName(value="transactionHash")
    private String transactionHash = null;
    @SerializedName(value="typeInt")
    private Long typeInt = null;
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="code")
    private Long code = null;
    @SerializedName(value="message")
    private String message = null;
    @SerializedName(value="transactionId")
    private String transactionId = null;
    @SerializedName(value="accountKey")
    private String accountKey = null;

    public TransactionResult from(String from) {
        this.from = from;
        return this;
    }

    @Schema(example="0x85b98485444c89880cd9c48807cef727c296f2da", required=true, description="\ud2b8\ub79c\uc7ad\uc158\uc744 \ubcf4\ub0b8 Klaytn \uacc4\uc815 \uc8fc\uc18c")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public TransactionResult gas(Long gas) {
        this.gas = gas;
        return this;
    }

    @Schema(example="1000000", required=true, description="\ud574\ub2f9 \ud2b8\ub79c\uc7ad\uc158\uc744 \ubcf4\ub0bc \ub54c \uc0ac\uc6a9\ud560 \ud2b8\ub79c\uc7ad\uc158 \uc218\uc218\ub8cc(gas)\uc758 \ucd5c\ub300\uac12")
    public Long getGas() {
        return this.gas;
    }

    public void setGas(Long gas) {
        this.gas = gas;
    }

    public TransactionResult gasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
        return this;
    }

    @Schema(example="0x5d21dba00", required=true, description="\ud574\ub2f9 \ud2b8\ub79c\uc7ad\uc158\uc744 \ubcf4\ub0bc \ub54c \uc0ac\uc6a9\ud560 \ud2b8\ub79c\uc7ad\uc158 \uc218\uc218\ub8cc(gas) \ube44\uc6a9")
    public String getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(String gasPrice) {
        this.gasPrice = gasPrice;
    }

    public TransactionResult input(String input) {
        this.input = input;
        return this;
    }

    @Schema(example="0x", description="\ud2b8\ub79c\uc7ad\uc158\uc744 Klaytn\uc5d0 \ubcf4\ub0bc \ub54c \ud568\uaed8 \ubcf4\ub0b4\ub294 \ub370\uc774\ud130")
    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public TransactionResult nonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    @Schema(example="0", required=true, description="\ud604\uc7ac \ud574\ub2f9 \ud2b8\ub79c\uc7ad\uc158\uc744 \ubcf4\ub0b4\ub294 \uc774\uac00 \uacfc\uac70\uc5d0 \ubcf4\ub0c8\ub358 \ubaa8\ub4e0 \ud2b8\ub79c\uc7ad\uc158\uc758 \uac1c\uc218")
    public Long getNonce() {
        return this.nonce;
    }

    public void setNonce(Long nonce) {
        this.nonce = nonce;
    }

    public TransactionResult rlp(String rlp) {
        this.rlp = rlp;
        return this;
    }

    @Schema(example="0xf870808505d21dba00830f424094a311e7022a4db250689c89d99848f74ea5098f7d89121111111111111111808207f5a03e7173bf7a303b4e1bb6f8723b494bcaa196cf7b9d7af18a22ceda7f2e9c9226a057bf51a5f52d900d58470f5e28f25881eb6d3837502ba0bab13f022398ddbc26", required=true, description="\ud574\ub2f9 \ud2b8\ub79c\uc7ad\uc158\uc758 RLP \uc9c1\ub82c\ud654(serialization) \uac12")
    public String getRlp() {
        return this.rlp;
    }

    public void setRlp(String rlp) {
        this.rlp = rlp;
    }

    public TransactionResult signatures(List<Signature> signatures) {
        this.signatures = signatures;
        return this;
    }

    public TransactionResult addSignaturesItem(Signature signaturesItem) {
        if (this.signatures == null) {
            this.signatures = new ArrayList<Signature>();
        }
        this.signatures.add(signaturesItem);
        return this;
    }

    @Schema(description="")
    public List<Signature> getSignatures() {
        return this.signatures;
    }

    public void setSignatures(List<Signature> signatures) {
        this.signatures = signatures;
    }

    public TransactionResult status(String status) {
        this.status = status;
        return this;
    }

    @Schema(example="Submitted", description="\ud574\ub2f9 \ud2b8\ub79c\uc7ad\uc158 \uc804\uc1a1 \ud6c4\uc758 \uc0c1\ud0dc(\u201cSubmitted\u201d \ub610\ub294 \u201cPending\u201d)")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public TransactionResult to(String to) {
        this.to = to;
        return this;
    }

    @Schema(example="0xa311e7022a4db250689c89d99848f74ea5098f7d", description="KLAY\ub97c \ubc1b\ub294 Klaytn \uacc4\uc815 \uc8fc\uc18c")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public TransactionResult transactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
        return this;
    }

    @Schema(example="0x433d70e6bdbce725ac9472e9fe1242fa0e5bdcd1b60fa21b3dcadf858055b47b", description="\ud574\ub2f9 \ud2b8\ub79c\uc7ad\uc158\uc5d0 \ub300\ud55c \ud574\uc2dc\uac12")
    public String getTransactionHash() {
        return this.transactionHash;
    }

    public void setTransactionHash(String transactionHash) {
        this.transactionHash = transactionHash;
    }

    public TransactionResult typeInt(Long typeInt) {
        this.typeInt = typeInt;
        return this;
    }

    @Schema(example="0", required=true, description="\ud574\ub2f9 \ud2b8\ub79c\uc7ad\uc158 \ud0c0\uc785\uc744 \ub098\ud0c0\ub0b4\ub294 \uc22b\uc790\uac12")
    public Long getTypeInt() {
        return this.typeInt;
    }

    public void setTypeInt(Long typeInt) {
        this.typeInt = typeInt;
    }

    public TransactionResult value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="0x121111111111111111", description="PEB \ub2e8\uc704\ub85c \ud658\uc0b0\ub41c KLAY")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public TransactionResult code(Long code) {
        this.code = code;
        return this;
    }

    @Schema(example="1065001", description="")
    public Long getCode() {
        return this.code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public TransactionResult message(String message) {
        this.message = message;
        return this;
    }

    @Schema(example="failed to send a raw transaction to klaytn node; -32000::insufficient funds of the sender for value ", description="")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public TransactionResult transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @Schema(example="0x7ee5d33b931e1c172dee21027aeeca31c33ddd44efd02cd3fd4fdfa0a86f888e", description="Multisig \ud2b8\ub79c\uc7ad\uc158\uc758 ID")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public TransactionResult accountKey(String accountKey) {
        this.accountKey = accountKey;
        return this;
    }

    @Schema(example="0x02a102044074a7a008a5ee6e50ef87cd57b83ca24e1e7cfa12305e27d0f13bddfd146d", description="\uc0c8\ub86d\uac8c \uc5c5\ub370\uc774\ud2b8\ub41c \uacc4\uc815 \ud0a4")
    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionResult transactionResult = (TransactionResult)o;
        return Objects.equals(this.from, transactionResult.from) && Objects.equals(this.gas, transactionResult.gas) && Objects.equals(this.gasPrice, transactionResult.gasPrice) && Objects.equals(this.input, transactionResult.input) && Objects.equals(this.nonce, transactionResult.nonce) && Objects.equals(this.rlp, transactionResult.rlp) && Objects.equals(this.signatures, transactionResult.signatures) && Objects.equals(this.status, transactionResult.status) && Objects.equals(this.to, transactionResult.to) && Objects.equals(this.transactionHash, transactionResult.transactionHash) && Objects.equals(this.typeInt, transactionResult.typeInt) && Objects.equals(this.value, transactionResult.value) && Objects.equals(this.code, transactionResult.code) && Objects.equals(this.message, transactionResult.message) && Objects.equals(this.transactionId, transactionResult.transactionId) && Objects.equals(this.accountKey, transactionResult.accountKey);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.gas, this.gasPrice, this.input, this.nonce, this.rlp, this.signatures, this.status, this.to, this.transactionHash, this.typeInt, this.value, this.code, this.message, this.transactionId, this.accountKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionResult {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    gas: ").append(this.toIndentedString(this.gas)).append("\n");
        sb.append("    gasPrice: ").append(this.toIndentedString(this.gasPrice)).append("\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    rlp: ").append(this.toIndentedString(this.rlp)).append("\n");
        sb.append("    signatures: ").append(this.toIndentedString(this.signatures)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    transactionHash: ").append(this.toIndentedString(this.transactionHash)).append("\n");
        sb.append("    typeInt: ").append(this.toIndentedString(this.typeInt)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    accountKey: ").append(this.toIndentedString(this.accountKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

