/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty;

import io.jpower.kcp.netty.internal.CodecOutputList;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import java.util.concurrent.TimeUnit;

class Utils {
    Utils() {
    }

    static int milliSeconds() {
        return (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    static int itimediff(int later, int earlier) {
        return later - earlier;
    }

    static void fireExceptionAndClose(Channel channel, Throwable t, boolean close) {
        channel.pipeline().fireExceptionCaught(t);
        if (channel.isActive()) {
            Channel.Unsafe unsafe = channel.unsafe();
            unsafe.close(unsafe.voidPromise());
        }
    }

    static void fireChannelRead(Channel ch, CodecOutputList<ByteBuf> bufList) {
        ChannelPipeline pipeline = ch.pipeline();
        int size = bufList.size();
        if (size <= 0) {
            return;
        }
        int i2 = 0;
        while (i2 < size) {
            ByteBuf msg = bufList.getUnsafe(i2);
            pipeline.fireChannelRead(msg);
            ++i2;
        }
        pipeline.fireChannelReadComplete();
    }
}

