/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty;

import io.jpower.kcp.netty.UkcpClientChannel;
import io.jpower.kcp.netty.Utils;
import io.jpower.kcp.netty.internal.CodecOutputList;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.nio.AbstractNioMessageChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.List;

final class UkcpClientUdpChannel
extends AbstractNioMessageChannel {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(UkcpClientUdpChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final UkcpClientChannel ukcpChannel;
    boolean inputShutdown;

    private static DatagramChannel newSocket(SelectorProvider provider) {
        try {
            return provider.openDatagramChannel();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
    }

    public UkcpClientUdpChannel(UkcpClientChannel ukcpChannel) {
        this(ukcpChannel, UkcpClientUdpChannel.newSocket(DEFAULT_SELECTOR_PROVIDER));
    }

    public UkcpClientUdpChannel(UkcpClientChannel ukcpChannel, SelectorProvider provider) {
        this(ukcpChannel, UkcpClientUdpChannel.newSocket(provider));
    }

    public UkcpClientUdpChannel(UkcpClientChannel ukcpChannel, DatagramChannel socket) {
        super(null, socket, 1);
        this.ukcpChannel = ukcpChannel;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ChannelConfig config() {
        return this.ukcpChannel.config();
    }

    @Override
    protected UkcpClientUdpUnsafe newUnsafe() {
        return new UkcpClientUdpUnsafe();
    }

    @Override
    public boolean isActive() {
        DatagramChannel ch = this.javaChannel();
        return ch.isOpen() && ch.socket().isBound();
    }

    @Override
    protected DatagramChannel javaChannel() {
        return (DatagramChannel)super.javaChannel();
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.doBind0(localAddress);
    }

    private void doBind0(SocketAddress localAddress) throws Exception {
        if (PlatformDependent.javaVersion() >= 7) {
            SocketUtils.bind(this.javaChannel(), localAddress);
        } else {
            this.javaChannel().socket().bind(localAddress);
        }
    }

    @Override
    protected boolean doConnect(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
        if (localAddress != null) {
            this.doBind0(localAddress);
        }
        boolean success = false;
        try {
            this.javaChannel().connect(remoteAddress);
            success = true;
            int current = Utils.milliSeconds();
            int tsUp = this.ukcpChannel.kcpCheck(current);
            this.ukcpChannel.kcpTsUpdate(tsUp);
            this.ukcpChannel.scheduleUpdate(tsUp, current);
            return true;
        }
        finally {
            if (!success) {
                this.doClose();
            }
        }
    }

    @Override
    protected void doFinishConnect() throws Exception {
        throw new Error();
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        this.javaChannel().close();
        if (!this.ukcpChannel.closeAnother) {
            this.ukcpChannel.closeAnother = true;
            this.ukcpChannel.unsafe().close(this.ukcpChannel.unsafe().voidPromise());
        }
    }

    @Override
    protected void doBeginRead() throws Exception {
        if (this.inputShutdown) {
            return;
        }
        super.doBeginRead();
    }

    @Override
    protected int doReadMessages(List<Object> buf) throws Exception {
        DatagramChannel ch = this.javaChannel();
        ChannelConfig config = this.config();
        RecvByteBufAllocator.Handle allocHandle = this.unsafe().recvBufAllocHandle();
        ByteBuf data = allocHandle.allocate(config.getAllocator());
        allocHandle.attemptedBytesRead(data.writableBytes());
        boolean free = true;
        try {
            ByteBuffer nioData = data.internalNioBuffer(data.writerIndex(), data.writableBytes());
            int pos = nioData.position();
            int read = ch.read(nioData);
            if (read <= 0) {
                int n = read;
                return n;
            }
            allocHandle.lastBytesRead(nioData.position() - pos);
            buf.add(data.writerIndex(data.writerIndex() + allocHandle.lastBytesRead()));
            free = false;
            return 1;
        }
        catch (Throwable cause) {
            PlatformDependent.throwException(cause);
            return -1;
        }
        finally {
            if (free) {
                data.release();
            }
        }
    }

    @Override
    protected boolean doWriteMessage(Object msg, ChannelOutboundBuffer in) throws Exception {
        ByteBuf data = (ByteBuf)msg;
        int dataLen = data.readableBytes();
        if (dataLen == 0) {
            return true;
        }
        ByteBuffer nioData = data.internalNioBuffer(data.readerIndex(), dataLen);
        int writtenBytes = this.javaChannel().write(nioData);
        return writtenBytes > 0;
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (UkcpClientUdpChannel.isSingleDirectBuffer(buf)) {
                return buf;
            }
            return this.newDirectBuffer(buf);
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName(msg) + EXPECTED_TYPES);
    }

    private static boolean isSingleDirectBuffer(ByteBuf buf) {
        return buf.isDirect() && buf.nioBufferCount() == 1;
    }

    @Override
    protected boolean continueOnWriteError() {
        return true;
    }

    static /* synthetic */ UkcpClientChannel access$3(UkcpClientUdpChannel ukcpClientUdpChannel) {
        return ukcpClientUdpChannel.ukcpChannel;
    }

    static /* synthetic */ boolean access$4(UkcpClientUdpChannel ukcpClientUdpChannel, Throwable throwable) {
        return ukcpClientUdpChannel.closeOnReadError(throwable);
    }

    private final class UkcpClientUdpUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private final List<Object> readBuf;

        private UkcpClientUdpUnsafe() {
            super(UkcpClientUdpChannel.this);
            this.readBuf = new ArrayList<Object>();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void read() {
            if (!UkcpClientUdpUnsafe.$assertionsDisabled && !UkcpClientUdpChannel.this.eventLoop().inEventLoop()) {
                throw new AssertionError();
            }
            config = UkcpClientUdpChannel.this.config();
            pipeline = UkcpClientUdpChannel.this.pipeline();
            ukcpPipeline = UkcpClientUdpChannel.access$3(UkcpClientUdpChannel.this).pipeline();
            allocHandle = this.recvBufAllocHandle();
            allocHandle.reset(config);
            closed = false;
            exception = null;
            try {
                block29: {
                    block27: {
                        try {
                            while ((localRead = UkcpClientUdpChannel.this.doReadMessages(this.readBuf)) != 0) {
                                if (localRead < 0) {
                                    closed = true;
                                } else {
                                    allocHandle.incMessagesRead(localRead);
                                    if (allocHandle.continueReading()) continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable t) {
                            exception = t;
                        }
                        exception1 = null;
                        readBufSize = this.readBuf.size();
                        try {
                            i = 0;
                            while (i < readBufSize) {
                                byteBuf = (ByteBuf)this.readBuf.get(i);
                                UkcpClientUdpChannel.access$3(UkcpClientUdpChannel.this).kcpInput(byteBuf);
                                ++i;
                            }
                            if (readBufSize > 0) {
                                UkcpClientUdpChannel.access$3(UkcpClientUdpChannel.this).kcpTsUpdate(Utils.milliSeconds());
                            }
                        }
                        catch (Throwable t) {
                            exception1 = t;
                        }
                        if (exception1 != null || !UkcpClientUdpChannel.access$3(UkcpClientUdpChannel.this).kcpIsActive()) break block29;
                        mergeSegmentBuf = UkcpClientUdpChannel.access$3(UkcpClientUdpChannel.this).config().isMergeSegmentBuf();
                        recvBufList = null;
                        recv = false;
                        try {
                            if (!mergeSegmentBuf) ** GOTO lbl56
                            allocator = config.getAllocator();
                            while ((peekSize = UkcpClientUdpChannel.access$3(UkcpClientUdpChannel.this).kcpPeekSize()) >= 0) {
                                recv = true;
                                recvBuf = allocator.ioBuffer(peekSize);
                                UkcpClientUdpChannel.access$3(UkcpClientUdpChannel.this).kcpReceive(recvBuf);
                                ukcpPipeline.fireChannelRead(recvBuf);
                            }
                            break block27;
lbl-1000:
                            // 1 sources

                            {
                                recv = true;
                                if (recvBufList == null) {
                                    recvBufList = CodecOutputList.newInstance();
                                }
                                UkcpClientUdpChannel.access$3(UkcpClientUdpChannel.this).kcpReceive(recvBufList);
lbl56:
                                // 2 sources

                                ** while (UkcpClientUdpChannel.access$3((UkcpClientUdpChannel)UkcpClientUdpChannel.this).kcpCanRecv())
                            }
lbl57:
                            // 1 sources

                        }
                        catch (Throwable t) {
                            exception1 = t;
                        }
                    }
                    if (recv) {
                        if (mergeSegmentBuf) {
                            ukcpPipeline.fireChannelReadComplete();
                        } else {
                            Utils.fireChannelRead(UkcpClientUdpChannel.access$3(UkcpClientUdpChannel.this), recvBufList);
                            recvBufList.recycle();
                        }
                    }
                }
                this.clearAndReleaseReadBuf();
                allocHandle.readComplete();
                if (exception != null) {
                    closed = UkcpClientUdpChannel.access$4(UkcpClientUdpChannel.this, exception);
                    ukcpPipeline.fireExceptionCaught(exception);
                }
                if (exception1 != null) {
                    closed = true;
                    ukcpPipeline.fireExceptionCaught(exception1);
                }
                if (closed) {
                    UkcpClientUdpChannel.this.inputShutdown = true;
                    if (UkcpClientUdpChannel.this.isOpen()) {
                        this.close(this.voidPromise());
                    }
                }
            }
            finally {
                if (!config.isAutoRead()) {
                    this.removeReadOp();
                }
            }
        }

        private void clearAndReleaseReadBuf() {
            int size = this.readBuf.size();
            int i2 = 0;
            while (i2 < size) {
                Object msg = this.readBuf.get(i2);
                ReferenceCountUtil.release(msg);
                ++i2;
            }
            this.readBuf.clear();
        }
    }
}

