/*
 * Decompiled with CFR 0.152.
 */
package io.jpower.kcp.netty;

import io.jpower.kcp.netty.KcpMetric;
import io.jpower.kcp.netty.KcpOutput;
import io.jpower.kcp.netty.internal.ReItrLinkedList;
import io.jpower.kcp.netty.internal.ReusableIterator;
import io.jpower.kcp.netty.internal.ReusableListIterator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.List;

public class Kcp {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(Kcp.class);
    private static final SecureRandom secureRandom = new SecureRandom();
    public static final int IKCP_RTO_NDL = 30;
    public static final int IKCP_RTO_MIN = 100;
    public static final int IKCP_RTO_DEF = 200;
    public static final int IKCP_RTO_MAX = 60000;
    public static final byte IKCP_CMD_PUSH = 81;
    public static final byte IKCP_CMD_ACK = 82;
    public static final byte IKCP_CMD_WASK = 83;
    public static final byte IKCP_CMD_WINS = 84;
    public static final int IKCP_ASK_SEND = 1;
    public static final int IKCP_ASK_TELL = 2;
    public static final int IKCP_WND_SND = 256;
    public static final int IKCP_WND_RCV = 256;
    public static final int IKCP_MTU_DEF = 1400;
    public static final int IKCP_ACK_FAST = 3;
    public static final int IKCP_INTERVAL = 100;
    public static final int IKCP_OVERHEAD = 28;
    public static final int IKCP_DEADLINK = 20;
    public static final int IKCP_THRESH_INIT = 2;
    public static final int IKCP_THRESH_MIN = 2;
    public static final int IKCP_PROBE_INIT = 7000;
    public static final int IKCP_PROBE_LIMIT = 120000;
    public static final int IKCP_FASTACK_LIMIT = 5;
    private long conv;
    private int mtu = 1400;
    private int mss = this.mtu - 28;
    private int state;
    private long sndUna;
    private long sndNxt;
    private long rcvNxt;
    private int tsRecent;
    private int tsLastack;
    private int ssthresh = 2;
    private int rxRttvar;
    private int rxSrtt;
    private int rxRto = 200;
    private int rxMinrto = 100;
    private int sndWnd = 256;
    private int rcvWnd = 256;
    private int rmtWnd = 256;
    private int cwnd;
    private int probe;
    private int current;
    private int interval = 100;
    private int tsFlush = 100;
    private int xmit;
    private int maxSegXmit;
    private boolean nodelay;
    private boolean updated;
    private int tsProbe;
    private int probeWait;
    private int deadLink = 20;
    private int incr;
    private LinkedList<Segment> sndQueue = new LinkedList();
    private ReItrLinkedList<Segment> rcvQueue = new ReItrLinkedList();
    private ReItrLinkedList<Segment> sndBuf = new ReItrLinkedList();
    private ReItrLinkedList<Segment> rcvBuf = new ReItrLinkedList();
    private ReusableListIterator<Segment> rcvQueueItr = this.rcvQueue.listIterator();
    private ReusableListIterator<Segment> sndBufItr = this.sndBuf.listIterator();
    private ReusableListIterator<Segment> rcvBufItr = this.rcvBuf.listIterator();
    private int[] acklist = new int[8];
    private int ackcount;
    private Object user;
    private int fastresend;
    private int fastlimit = 5;
    private boolean nocwnd;
    private boolean stream;
    private KcpOutput output;
    private ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
    private boolean autoSetConv;
    private KcpMetric metric = new KcpMetric(this);

    private static long int2Uint(int i2) {
        return (long)i2 & 0xFFFFFFFFL;
    }

    private static int ibound(int lower2, int middle, int upper2) {
        return Math.min(Math.max(lower2, middle), upper2);
    }

    private static int itimediff(int later, int earlier) {
        return later - earlier;
    }

    private static int itimediff(long later, long earlier) {
        return (int)(later - earlier);
    }

    protected static void output(ByteBuf data, Kcp kcp) {
        if (log.isDebugEnabled()) {
            log.debug("{} [RO] {} bytes", (Object)kcp, (Object)data.readableBytes());
        }
        if (data.readableBytes() == 0) {
            return;
        }
        kcp.output.out(data, kcp);
    }

    private static int encodeSeg(ByteBuf buf, Segment seg) {
        int offset = buf.writerIndex();
        buf.writeLong(seg.conv);
        buf.writeByte(seg.cmd);
        buf.writeByte(seg.frg);
        buf.writeShortLE(seg.wnd);
        buf.writeIntLE(seg.ts);
        buf.writeIntLE((int)seg.sn);
        buf.writeIntLE((int)seg.una);
        buf.writeIntLE(seg.data.readableBytes());
        return buf.writerIndex() - offset;
    }

    public Kcp(long conv, KcpOutput output) {
        this.conv = conv;
        this.output = output;
    }

    public void release() {
        this.release(this.sndBuf);
        this.release(this.rcvBuf);
        this.release(this.sndQueue);
        this.release(this.rcvQueue);
    }

    private void release(List<Segment> segQueue) {
        for (Segment seg : segQueue) {
            seg.recycle(true);
        }
        segQueue.clear();
    }

    private ByteBuf tryCreateOrOutput(ByteBuf buffer, int need) {
        if (buffer == null) {
            buffer = this.createFlushByteBuf();
        } else if (buffer.readableBytes() + need > this.mtu) {
            Kcp.output(buffer, this);
            buffer = this.createFlushByteBuf();
        }
        return buffer;
    }

    private ByteBuf createFlushByteBuf() {
        return this.byteBufAllocator.ioBuffer(this.mtu);
    }

    public int recv(ByteBuf buf) {
        if (this.rcvQueue.isEmpty()) {
            return -1;
        }
        int peekSize = this.peekSize();
        if (peekSize < 0) {
            return -2;
        }
        if (peekSize > buf.maxCapacity()) {
            return -3;
        }
        boolean recover = false;
        if (this.rcvQueue.size() >= this.rcvWnd) {
            recover = true;
        }
        int len2 = 0;
        ReusableIterator itr = this.rcvQueueItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            len2 += seg.data.readableBytes();
            buf.writeBytes(seg.data);
            short fragment = seg.frg;
            if (log.isDebugEnabled()) {
                log.debug("{} recv sn={}", (Object)this, (Object)seg.sn);
            }
            itr.remove();
            seg.recycle(true);
            if (fragment == 0) break;
        }
        assert (len2 == peekSize);
        this.moveRcvData();
        if (this.rcvQueue.size() < this.rcvWnd && recover) {
            this.probe |= 2;
        }
        return len2;
    }

    public int recv(List<ByteBuf> bufList) {
        if (this.rcvQueue.isEmpty()) {
            return -1;
        }
        int peekSize = this.peekSize();
        if (peekSize < 0) {
            return -2;
        }
        boolean recover = false;
        if (this.rcvQueue.size() >= this.rcvWnd) {
            recover = true;
        }
        int len2 = 0;
        ReusableIterator itr = this.rcvQueueItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            len2 += seg.data.readableBytes();
            bufList.add(seg.data);
            short fragment = seg.frg;
            if (log.isDebugEnabled()) {
                log.debug("{} recv sn={}", (Object)this, (Object)seg.sn);
            }
            itr.remove();
            seg.recycle(false);
            if (fragment == 0) break;
        }
        assert (len2 == peekSize);
        this.moveRcvData();
        if (this.rcvQueue.size() < this.rcvWnd && recover) {
            this.probe |= 2;
        }
        return len2;
    }

    public int peekSize() {
        if (this.rcvQueue.isEmpty()) {
            return -1;
        }
        Segment seg = this.rcvQueue.peek();
        if (seg.frg == 0) {
            return seg.data.readableBytes();
        }
        if (this.rcvQueue.size() < seg.frg + 1) {
            return -1;
        }
        int len2 = 0;
        ReusableIterator itr = this.rcvQueueItr.rewind();
        while (itr.hasNext()) {
            Segment s2 = (Segment)itr.next();
            len2 += s2.data.readableBytes();
            if (s2.frg == 0) break;
        }
        return len2;
    }

    public boolean canRecv() {
        if (this.rcvQueue.isEmpty()) {
            return false;
        }
        Segment seg = this.rcvQueue.peek();
        if (seg.frg == 0) {
            return true;
        }
        return this.rcvQueue.size() >= seg.frg + 1;
    }

    public int send(ByteBuf buf) {
        Segment last;
        ByteBuf lastData;
        int lastLen;
        assert (this.mss > 0);
        int len2 = buf.readableBytes();
        if (len2 == 0) {
            return -1;
        }
        if (this.stream && !this.sndQueue.isEmpty() && (lastLen = (lastData = (last = this.sndQueue.peekLast()).data).readableBytes()) < this.mss) {
            int extend;
            int capacity = this.mss - lastLen;
            int n = extend = len2 < capacity ? len2 : capacity;
            if (lastData.maxWritableBytes() < extend) {
                ByteBuf newBuf = this.byteBufAllocator.ioBuffer(lastLen + extend);
                newBuf.writeBytes(lastData);
                lastData.release();
                ByteBuf byteBuf = newBuf;
                last.data = byteBuf;
                lastData = byteBuf;
            }
            lastData.writeBytes(buf, extend);
            len2 = buf.readableBytes();
            if (len2 == 0) {
                return 0;
            }
        }
        int count = 0;
        count = len2 <= this.mss ? 1 : (len2 + this.mss - 1) / this.mss;
        if (!this.stream && count > 255) {
            return -2;
        }
        if (count == 0) {
            count = 1;
        }
        int i2 = 0;
        while (i2 < count) {
            int size = len2 > this.mss ? this.mss : len2;
            Segment seg = Segment.createSegment(buf.readRetainedSlice(size));
            seg.frg = (short)(this.stream ? 0 : count - i2 - 1);
            this.sndQueue.add(seg);
            len2 = buf.readableBytes();
            ++i2;
        }
        return 0;
    }

    private void updateAck(int rtt) {
        if (this.rxSrtt == 0) {
            this.rxSrtt = rtt;
            this.rxRttvar = rtt / 2;
        } else {
            int delta = rtt - this.rxSrtt;
            if (delta < 0) {
                delta = -delta;
            }
            this.rxRttvar = (3 * this.rxRttvar + delta) / 4;
            this.rxSrtt = (7 * this.rxSrtt + rtt) / 8;
            if (this.rxSrtt < 1) {
                this.rxSrtt = 1;
            }
        }
        int rto = this.rxSrtt + Math.max(this.interval, 4 * this.rxRttvar);
        this.rxRto = Kcp.ibound(this.rxMinrto, rto, 60000);
    }

    private void shrinkBuf() {
        if (this.sndBuf.size() > 0) {
            Segment seg = this.sndBuf.peek();
            this.sndUna = seg.sn;
        } else {
            this.sndUna = this.sndNxt;
        }
    }

    private void parseAck(long sn) {
        if (Kcp.itimediff(sn, this.sndUna) < 0 || Kcp.itimediff(sn, this.sndNxt) >= 0) {
            return;
        }
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            if (sn == seg.sn) {
                itr.remove();
                seg.recycle(true);
                break;
            }
            if (Kcp.itimediff(sn, seg.sn) < 0) break;
        }
    }

    private void parseUna(long una) {
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            if (Kcp.itimediff(una, seg.sn) <= 0) break;
            itr.remove();
            seg.recycle(true);
        }
    }

    private void parseFastack(long sn) {
        if (Kcp.itimediff(sn, this.sndUna) < 0 || Kcp.itimediff(sn, this.sndNxt) >= 0) {
            return;
        }
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            if (Kcp.itimediff(sn, seg.sn) < 0) break;
            if (sn == seg.sn) continue;
            Segment segment = seg;
            segment.fastack = segment.fastack + 1;
        }
    }

    private void ackPush(long sn, int ts) {
        int newSize = 2 * (this.ackcount + 1);
        if (newSize > this.acklist.length) {
            int newCapacity = this.acklist.length << 1;
            if (newCapacity < 0) {
                throw new OutOfMemoryError();
            }
            int[] newArray = new int[newCapacity];
            System.arraycopy(this.acklist, 0, newArray, 0, this.acklist.length);
            this.acklist = newArray;
        }
        this.acklist[2 * this.ackcount] = (int)sn;
        this.acklist[2 * this.ackcount + 1] = ts;
        ++this.ackcount;
    }

    private void parseData(Segment newSeg) {
        long sn = newSeg.sn;
        if (Kcp.itimediff(sn, this.rcvNxt + (long)this.rcvWnd) >= 0 || Kcp.itimediff(sn, this.rcvNxt) < 0) {
            newSeg.recycle(true);
            return;
        }
        boolean repeat = false;
        boolean findPos = false;
        ReusableListIterator<Segment> listItr = null;
        if (this.rcvBuf.size() > 0) {
            listItr = this.rcvBufItr.rewind(this.rcvBuf.size());
            while (listItr.hasPrevious()) {
                Segment seg = (Segment)listItr.previous();
                if (seg.sn == sn) {
                    repeat = true;
                    break;
                }
                if (Kcp.itimediff(sn, seg.sn) <= 0) continue;
                findPos = true;
                break;
            }
        }
        if (repeat) {
            newSeg.recycle(true);
        } else if (listItr == null) {
            this.rcvBuf.add(newSeg);
        } else {
            if (findPos) {
                listItr.next();
            }
            listItr.add(newSeg);
        }
        this.moveRcvData();
    }

    private void moveRcvData() {
        ReusableIterator itr = this.rcvBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            if (seg.sn != this.rcvNxt || this.rcvQueue.size() >= this.rcvWnd) break;
            itr.remove();
            this.rcvQueue.add(seg);
            ++this.rcvNxt;
        }
    }

    public int input(ByteBuf data) {
        long oldSndUna = this.sndUna;
        long maxack = 0L;
        boolean flag = false;
        if (log.isDebugEnabled()) {
            log.debug("{} [RI] {} bytes", (Object)this, (Object)data.readableBytes());
        }
        if (data == null || data.readableBytes() < 28) {
            return -1;
        }
        while (data.readableBytes() >= 28) {
            long conv = data.readLong();
            if (!(conv == this.conv || this.conv == 0L && this.autoSetConv)) {
                return -4;
            }
            byte cmd = data.readByte();
            short frg = data.readUnsignedByte();
            int wnd = data.readUnsignedShortLE();
            int ts = data.readIntLE();
            long sn = data.readUnsignedIntLE();
            long una = data.readUnsignedIntLE();
            int len2 = data.readIntLE();
            if (data.readableBytes() < len2 || len2 < 0) {
                return -2;
            }
            if (cmd != 81 && cmd != 82 && cmd != 83 && cmd != 84) {
                return -3;
            }
            if (this.conv == 0L && this.autoSetConv) {
                this.conv = conv;
            }
            this.rmtWnd = wnd;
            this.parseUna(una);
            this.shrinkBuf();
            boolean readed = false;
            int current = this.current;
            switch (cmd) {
                case 82: {
                    int rtt = Kcp.itimediff(current, ts);
                    if (rtt >= 0) {
                        this.updateAck(rtt);
                    }
                    this.parseAck(sn);
                    this.shrinkBuf();
                    if (!flag) {
                        flag = true;
                        maxack = sn;
                    } else if (Kcp.itimediff(sn, maxack) > 0) {
                        maxack = sn;
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug("{} input ack: sn={}, rtt={}, rto={}", this, sn, rtt, this.rxRto);
                    break;
                }
                case 81: {
                    if (Kcp.itimediff(sn, this.rcvNxt + (long)this.rcvWnd) < 0) {
                        this.ackPush(sn, ts);
                        if (Kcp.itimediff(sn, this.rcvNxt) >= 0) {
                            Segment seg;
                            if (len2 > 0) {
                                seg = Segment.createSegment(data.readRetainedSlice(len2));
                                readed = true;
                            } else {
                                seg = Segment.createSegment(this.byteBufAllocator, 0);
                            }
                            seg.conv = conv;
                            seg.cmd = cmd;
                            seg.frg = frg;
                            seg.wnd = wnd;
                            seg.ts = ts;
                            seg.sn = sn;
                            seg.una = una;
                            this.parseData(seg);
                        }
                    }
                    if (!log.isDebugEnabled()) break;
                    log.debug("{} input push: sn={}, una={}, ts={}", this, sn, una, ts);
                    break;
                }
                case 83: {
                    this.probe |= 2;
                    if (!log.isDebugEnabled()) break;
                    log.debug("{} input ask", (Object)this);
                    break;
                }
                case 84: {
                    if (!log.isDebugEnabled()) break;
                    log.debug("{} input tell: {}", (Object)this, (Object)wnd);
                    break;
                }
                default: {
                    return -3;
                }
            }
            if (readed) continue;
            data.skipBytes(len2);
        }
        if (flag) {
            this.parseFastack(maxack);
        }
        if (Kcp.itimediff(this.sndUna, oldSndUna) > 0 && this.cwnd < this.rmtWnd) {
            int mss = this.mss;
            if (this.cwnd < this.ssthresh) {
                ++this.cwnd;
                this.incr += mss;
            } else {
                if (this.incr < mss) {
                    this.incr = mss;
                }
                this.incr += mss * mss / this.incr + mss / 16;
                if ((this.cwnd + 1) * mss <= this.incr) {
                    ++this.cwnd;
                }
            }
            if (this.cwnd > this.rmtWnd) {
                this.cwnd = this.rmtWnd;
                this.incr = this.rmtWnd * mss;
            }
        }
        return 0;
    }

    private int wndUnused() {
        if (this.rcvQueue.size() < this.rcvWnd) {
            return this.rcvWnd - this.rcvQueue.size();
        }
        return 0;
    }

    private void flush() {
        int current = this.current;
        if (!this.updated) {
            return;
        }
        Segment seg = Segment.createSegment(this.byteBufAllocator, 0);
        seg.conv = this.conv;
        seg.cmd = (byte)82;
        seg.frg = (short)0;
        seg.wnd = this.wndUnused();
        seg.una = this.rcvNxt;
        seg.sn = 0L;
        seg.ts = 0;
        ByteBuf buffer = null;
        int count = this.ackcount;
        int i2 = 0;
        while (i2 < count) {
            buffer = this.tryCreateOrOutput(buffer, 28);
            seg.sn = Kcp.int2Uint(this.acklist[i2 * 2]);
            seg.ts = this.acklist[i2 * 2 + 1];
            Kcp.encodeSeg(buffer, seg);
            if (log.isDebugEnabled()) {
                log.debug("{} flush ack: sn={}, ts={}", this, seg.sn, seg.ts);
            }
            ++i2;
        }
        this.ackcount = 0;
        if (this.rmtWnd == 0) {
            if (this.probeWait == 0) {
                this.probeWait = 7000;
                this.tsProbe = current + this.probeWait;
            } else if (Kcp.itimediff(current, this.tsProbe) >= 0) {
                if (this.probeWait < 7000) {
                    this.probeWait = 7000;
                }
                this.probeWait += this.probeWait / 2;
                if (this.probeWait > 120000) {
                    this.probeWait = 120000;
                }
                this.tsProbe = current + this.probeWait;
                this.probe |= 1;
            }
        } else {
            this.tsProbe = 0;
            this.probeWait = 0;
        }
        if ((this.probe & 1) != 0) {
            seg.cmd = (byte)83;
            buffer = this.tryCreateOrOutput(buffer, 28);
            Kcp.encodeSeg(buffer, seg);
            if (log.isDebugEnabled()) {
                log.debug("{} flush ask", (Object)this);
            }
        }
        if ((this.probe & 2) != 0) {
            seg.cmd = (byte)84;
            buffer = this.tryCreateOrOutput(buffer, 28);
            Kcp.encodeSeg(buffer, seg);
            if (log.isDebugEnabled()) {
                log.debug("{} flush tell: wnd={}", (Object)this, (Object)seg.wnd);
            }
        }
        this.probe = 0;
        int cwnd0 = Math.min(this.sndWnd, this.rmtWnd);
        if (!this.nocwnd) {
            cwnd0 = Math.min(this.cwnd, cwnd0);
        }
        while (Kcp.itimediff(this.sndNxt, this.sndUna + (long)cwnd0) < 0) {
            Segment newSeg = this.sndQueue.poll();
            if (newSeg == null) break;
            this.sndBuf.add(newSeg);
            newSeg.conv = this.conv;
            newSeg.cmd = (byte)81;
            newSeg.wnd = seg.wnd;
            newSeg.ts = current;
            newSeg.sn = this.sndNxt++;
            newSeg.una = this.rcvNxt;
            newSeg.resendts = current;
            newSeg.rto = this.rxRto;
            newSeg.fastack = 0;
            newSeg.xmit = 0;
        }
        int resent = this.fastresend > 0 ? this.fastresend : Integer.MAX_VALUE;
        int rtomin = this.nodelay ? 0 : this.rxRto >> 3;
        int change = 0;
        boolean lost = false;
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            Segment segment = (Segment)itr.next();
            boolean needsend = false;
            if (segment.xmit == 0) {
                needsend = true;
                this.incrXmit(segment);
                segment.rto = this.rxRto;
                segment.resendts = current + segment.rto + rtomin;
                if (log.isDebugEnabled()) {
                    log.debug("{} flush data: sn={}, resendts={}", this, segment.sn, segment.resendts - current);
                }
            } else if (Kcp.itimediff(current, segment.resendts) >= 0) {
                needsend = true;
                this.incrXmit(segment);
                ++this.xmit;
                segment.fastack = 0;
                if (!this.nodelay) {
                    Segment segment2 = segment;
                    segment2.rto = segment2.rto + this.rxRto;
                } else {
                    Segment segment3 = segment;
                    segment3.rto = segment3.rto + this.rxRto / 2;
                }
                segment.resendts = current + segment.rto;
                lost = true;
                if (log.isDebugEnabled()) {
                    log.debug("{} resend. sn={}, xmit={}, resendts={}", this, segment.sn, segment.xmit, segment.resendts - current);
                }
            } else if (segment.fastack >= resent && (segment.xmit <= this.fastlimit || this.fastlimit <= 0)) {
                needsend = true;
                this.incrXmit(segment);
                segment.fastack = 0;
                segment.resendts = current + segment.rto;
                ++change;
                if (log.isDebugEnabled()) {
                    log.debug("{} fastresend. sn={}, xmit={}, resendts={} ", this, segment.sn, segment.xmit, segment.resendts - current);
                }
            }
            if (!needsend) continue;
            segment.ts = current;
            segment.wnd = seg.wnd;
            segment.una = this.rcvNxt;
            ByteBuf segData = segment.data;
            int segLen = segData.readableBytes();
            int need = 28 + segLen;
            buffer = this.tryCreateOrOutput(buffer, need);
            Kcp.encodeSeg(buffer, segment);
            if (segLen > 0) {
                buffer.writeBytes(segData, segData.readerIndex(), segLen);
            }
            if (segment.xmit < this.deadLink) continue;
            this.state = -1;
        }
        if (buffer != null) {
            if (buffer.readableBytes() > 0) {
                Kcp.output(buffer, this);
            } else {
                buffer.release();
            }
        }
        seg.recycle(true);
        if (change > 0) {
            int inflight = (int)(this.sndNxt - this.sndUna);
            this.ssthresh = inflight / 2;
            if (this.ssthresh < 2) {
                this.ssthresh = 2;
            }
            this.cwnd = this.ssthresh + resent;
            this.incr = this.cwnd * this.mss;
        }
        if (lost) {
            this.ssthresh = cwnd0 / 2;
            if (this.ssthresh < 2) {
                this.ssthresh = 2;
            }
            this.cwnd = 1;
            this.incr = this.mss;
        }
        if (this.cwnd < 1) {
            this.cwnd = 1;
            this.incr = this.mss;
        }
    }

    public void update(int current) {
        int slap;
        this.current = current;
        if (!this.updated) {
            this.updated = true;
            this.tsFlush = this.current;
        }
        if ((slap = Kcp.itimediff(this.current, this.tsFlush)) >= 10000 || slap < -10000) {
            this.tsFlush = this.current;
            slap = 0;
        }
        if (slap >= 0) {
            this.tsFlush += this.interval;
            if (Kcp.itimediff(this.current, this.tsFlush) >= 0) {
                this.tsFlush = this.current + this.interval;
            }
        } else {
            this.tsFlush = this.current + this.interval;
        }
        this.flush();
    }

    public int check(int current) {
        int minimal;
        if (!this.updated) {
            return current;
        }
        int tsFlush = this.tsFlush;
        int slap = Kcp.itimediff(current, tsFlush);
        if (slap >= 10000 || slap < -10000) {
            tsFlush = current;
            slap = 0;
        }
        if (slap >= 0) {
            return current;
        }
        int tmFlush = Kcp.itimediff(tsFlush, current);
        int tmPacket = Integer.MAX_VALUE;
        ReusableIterator itr = this.sndBufItr.rewind();
        while (itr.hasNext()) {
            Segment seg = (Segment)itr.next();
            int diff = Kcp.itimediff(seg.resendts, current);
            if (diff <= 0) {
                return current;
            }
            if (diff >= tmPacket) continue;
            tmPacket = diff;
        }
        int n = minimal = tmPacket < tmFlush ? tmPacket : tmFlush;
        if (minimal >= this.interval) {
            minimal = this.interval;
        }
        return current + minimal;
    }

    public boolean checkFlush() {
        if (this.ackcount > 0) {
            return true;
        }
        if (this.probe != 0) {
            return true;
        }
        if (this.sndBuf.size() > 0) {
            return true;
        }
        return this.sndQueue.size() > 0;
    }

    private void incrXmit(Segment seg) {
        Segment segment = seg;
        int n = segment.xmit + 1;
        segment.xmit = n;
        if (n > this.metric.maxSegXmit()) {
            this.metric.maxSegXmit(seg.xmit);
        }
    }

    public int getMtu() {
        return this.mtu;
    }

    public int setMtu(int mtu) {
        if (mtu < 28 || mtu < 50) {
            return -1;
        }
        this.mtu = mtu;
        this.mss = mtu - 28;
        return 0;
    }

    public int getInterval() {
        return this.interval;
    }

    public int setInterval(int interval) {
        if (interval > 5000) {
            interval = 5000;
        } else if (interval < 10) {
            interval = 10;
        }
        this.interval = interval;
        return 0;
    }

    public int nodelay(boolean nodelay, int interval, int resend, boolean nc) {
        this.nodelay = nodelay;
        this.rxMinrto = nodelay ? 30 : 100;
        if (interval >= 0) {
            if (interval > 5000) {
                interval = 5000;
            } else if (interval < 10) {
                interval = 10;
            }
            this.interval = interval;
        }
        if (resend >= 0) {
            this.fastresend = resend;
        }
        this.nocwnd = nc;
        return 0;
    }

    public int wndsize(int sndWnd, int rcvWnd) {
        if (sndWnd > 0) {
            this.sndWnd = sndWnd;
        }
        if (rcvWnd > 0) {
            this.rcvWnd = rcvWnd;
        }
        return 0;
    }

    public int waitSnd() {
        return this.sndBuf.size() + this.sndQueue.size();
    }

    public long getConv() {
        return this.conv;
    }

    public void setConv(long conv) {
        this.conv = conv;
    }

    public int getConv1() {
        return (int)(this.conv >> 32);
    }

    public int getConv2() {
        return (int)(this.conv & 0xFFFFFFFFL);
    }

    protected void generateConv() {
        this.conv = secureRandom.nextLong();
    }

    public Object getUser() {
        return this.user;
    }

    public void setUser(Object user) {
        this.user = user;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public boolean isNodelay() {
        return this.nodelay;
    }

    public void setNodelay(boolean nodelay) {
        this.nodelay = nodelay;
        this.rxMinrto = nodelay ? 30 : 100;
    }

    public int getFastresend() {
        return this.fastresend;
    }

    public void setFastresend(int fastresend) {
        this.fastresend = fastresend;
    }

    public int getFastlimit() {
        return this.fastlimit;
    }

    public void setFastlimit(int fastlimit) {
        this.fastlimit = fastlimit;
    }

    public boolean isNocwnd() {
        return this.nocwnd;
    }

    public void setNocwnd(boolean nocwnd) {
        this.nocwnd = nocwnd;
    }

    public int getRxMinrto() {
        return this.rxMinrto;
    }

    public void setRxMinrto(int rxMinrto) {
        this.rxMinrto = rxMinrto;
    }

    public int getRcvWnd() {
        return this.rcvWnd;
    }

    public void setRcvWnd(int rcvWnd) {
        this.rcvWnd = rcvWnd;
    }

    public int getSndWnd() {
        return this.sndWnd;
    }

    public void setSndWnd(int sndWnd) {
        this.sndWnd = sndWnd;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public int getDeadLink() {
        return this.deadLink;
    }

    public void setDeadLink(int deadLink) {
        this.deadLink = deadLink;
    }

    public void setByteBufAllocator(ByteBufAllocator byteBufAllocator) {
        this.byteBufAllocator = byteBufAllocator;
    }

    public boolean isAutoSetConv() {
        return this.autoSetConv;
    }

    public void setAutoSetConv(boolean autoSetConv) {
        this.autoSetConv = autoSetConv;
    }

    int getSrtt() {
        return this.rxSrtt;
    }

    int getRttvar() {
        return this.rxRttvar;
    }

    int getRto() {
        return this.rxRto;
    }

    long getSndNxt() {
        return this.sndNxt;
    }

    long getSndUna() {
        return this.sndUna;
    }

    long getRcvNxt() {
        return this.rcvNxt;
    }

    int getCwnd() {
        return this.cwnd;
    }

    int getXmit() {
        return this.xmit;
    }

    public KcpMetric getMetric() {
        return this.metric;
    }

    public String toString() {
        return "Kcp(conv=" + this.conv + ')';
    }

    private static class Segment {
        private final ObjectPool.Handle<Segment> recyclerHandle;
        private long conv;
        private byte cmd;
        private short frg;
        private int wnd;
        private int ts;
        private long sn;
        private long una;
        private int resendts;
        private int rto;
        private int fastack;
        private int xmit;
        private ByteBuf data;
        private static final ObjectPool<Segment> RECYCLER = ObjectPool.newPool(Segment::new);

        private Segment(ObjectPool.Handle<Segment> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        void recycle(boolean releaseBuf) {
            this.conv = 0L;
            this.cmd = 0;
            this.frg = 0;
            this.wnd = 0;
            this.ts = 0;
            this.sn = 0L;
            this.una = 0L;
            this.resendts = 0;
            this.rto = 0;
            this.fastack = 0;
            this.xmit = 0;
            if (releaseBuf) {
                this.data.release();
            }
            this.data = null;
            this.recyclerHandle.recycle(this);
        }

        static Segment createSegment(ByteBufAllocator byteBufAllocator, int size) {
            Segment seg = RECYCLER.get();
            seg.data = size == 0 ? byteBufAllocator.ioBuffer(0, 0) : byteBufAllocator.ioBuffer(size);
            return seg;
        }

        static Segment createSegment(ByteBuf buf) {
            Segment seg = RECYCLER.get();
            seg.data = buf;
            return seg;
        }
    }
}

