/*
 * Decompiled with CFR 0.152.
 */
package express.http;

import io.javalin.http.Context;
import io.javalin.http.UploadedFile;
import java.util.List;
import java.util.Map;

public class Request {
    private final Context ctx;

    public Request(Context ctx) {
        this.ctx = ctx;
    }

    public Context ctx() {
        return this.ctx;
    }

    public String baseUrl() {
        return this.ctx.endpointHandlerPath();
    }

    public Map body() {
        return this.ctx.bodyAsClass(Map.class);
    }

    public <T> T body(Class<T> klass) {
        return this.ctx.bodyAsClass(klass);
    }

    public byte[] bodyAsBytes() {
        return this.ctx.bodyAsBytes();
    }

    public String cookie(String name) {
        return this.ctx.cookie(name);
    }

    public Map<String, String> cookies() {
        return this.ctx.cookieMap();
    }

    public String host() {
        return this.ctx.host();
    }

    public String hostname() {
        return this.ctx.host() + ":" + this.ctx.port();
    }

    public String ip() {
        return this.ctx.ip();
    }

    public String method() {
        return this.ctx.method();
    }

    public String originalUrl() {
        return this.ctx.fullUrl();
    }

    public Map<String, String> params() {
        return this.ctx.pathParamMap();
    }

    public String params(String key) {
        return this.ctx.pathParam(key);
    }

    public <T> T params(String key, Class<T> klass) {
        return (T)this.ctx.pathParam(key, klass);
    }

    public String path() {
        return this.ctx.path();
    }

    public String protocol() {
        return this.ctx.protocol();
    }

    public Map<String, List<String>> query() {
        return this.ctx.queryParamMap();
    }

    public String query(String key) {
        return this.ctx.queryParam(key);
    }

    public <T> T query(String key, Class<T> klass) {
        return (T)this.ctx.queryParam(key, klass);
    }

    public Map<String, List<String>> formData() {
        return this.ctx.formParamMap();
    }

    public String formData(String key) {
        return this.ctx.formParam(key);
    }

    public <T> T formData(String key, Class<T> klass) {
        return (T)this.ctx.formParam(key, klass);
    }

    public UploadedFile formDataFile(String key) {
        return this.ctx.uploadedFile(key);
    }

    public List<UploadedFile> formDataFiles(String key) {
        return this.ctx.uploadedFiles(key);
    }

    public boolean secure() {
        return this.protocol().equals("https");
    }

    public String[] subdomains() {
        String[] domains = this.ctx.url().split("\\.");
        return new String[]{domains[0], domains[1]};
    }

    public boolean xhr() {
        return this.ctx.header("X-Requested-With").equals("XMLHttpRequest");
    }

    public boolean accepts(String accept) {
        return this.ctx.header("Accept").equals(accept);
    }

    public String get(String header) {
        return this.ctx.header(header);
    }

    public boolean is(String contentType) {
        return this.ctx.contentType().equals(contentType);
    }

    public <T> Map<String, T> session() {
        return this.ctx.sessionAttributeMap();
    }

    public <T> T session(String key) {
        return this.ctx.sessionAttribute(key);
    }

    public void session(String key, Object value) {
        this.ctx.sessionAttribute(key, value);
    }
}

