/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.utils;

import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.net.proto.GetPlayerTokenRspOuterClass;
import emu.grasscutter.net.proto.QueryCurrRegionHttpRspOuterClass;
import emu.grasscutter.utils.FileUtils;
import java.security.SecureRandom;
import java.util.Base64;

public final class Crypto {
    private static final SecureRandom secureRandom = new SecureRandom();
    public static byte[] DISPATCH_KEY;
    public static byte[] DISPATCH_SEED;
    public static byte[] ENCRYPT_KEY;
    public static long ENCRYPT_SEED;
    public static byte[] ENCRYPT_SEED_BUFFER;

    public static void loadKeys() {
        DISPATCH_KEY = FileUtils.read(Configuration.KEYS_FOLDER + "/dispatchKey.bin");
        DISPATCH_SEED = FileUtils.read(Configuration.KEYS_FOLDER + "/dispatchSeed.bin");
        ENCRYPT_KEY = FileUtils.read(Configuration.KEYS_FOLDER + "/secretKey.bin");
        ENCRYPT_SEED_BUFFER = FileUtils.read(Configuration.KEYS_FOLDER + "/secretKeyBuffer.bin");
    }

    public static void xor(byte[] packet, byte[] key) {
        try {
            for (int i2 = 0; i2 < packet.length; ++i2) {
                int n = i2;
                packet[n] = (byte)(packet[n] ^ key[i2 % key.length]);
            }
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Crypto error.", e);
        }
    }

    public static void extractSecretKeyBuffer(byte[] data) {
        try {
            GetPlayerTokenRspOuterClass.GetPlayerTokenRsp p = GetPlayerTokenRspOuterClass.GetPlayerTokenRsp.parseFrom(data);
            FileUtils.write(Configuration.KEYS_FOLDER + "/secretKeyBuffer.bin", p.getSecretKeyBytes().toByteArray());
            Grasscutter.getLogger().info("Secret Key: " + p.getSecretKey());
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Crypto error.", e);
        }
    }

    public static void extractDispatchSeed(String data) {
        try {
            QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp p = QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp.parseFrom(Base64.getDecoder().decode(data));
            FileUtils.write(Configuration.KEYS_FOLDER + "/dispatchSeed.bin", p.getRegionInfo().getSecretKey().toByteArray());
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Crypto error.", e);
        }
    }

    public static byte[] createSessionKey(int length) {
        byte[] bytes = new byte[length];
        secureRandom.nextBytes(bytes);
        return bytes;
    }

    static {
        ENCRYPT_SEED = Long.parseUnsignedLong("11468049314633205968");
        ENCRYPT_SEED_BUFFER = new byte[0];
    }
}

