/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.utils;

import com.google.gson.JsonObject;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.game.mail.Mail;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;

public class ConfigContainer {
    public Structure folderStructure = new Structure();
    public Database databaseInfo = new Database();
    public Language language = new Language();
    public Account account = new Account();
    public Server server = new Server();
    public int version = ConfigContainer.version();

    private static int version() {
        return 3;
    }

    public static void updateConfig() {
        try {
            JsonObject configObject = Grasscutter.getGsonFactory().fromJson((Reader)new FileReader(Grasscutter.configFile), JsonObject.class);
            if (!configObject.has("version")) {
                Grasscutter.getLogger().info("Updating legacy ..");
                Grasscutter.saveConfig(null);
            }
        }
        catch (Exception configObject) {
            // empty catch block
        }
        int existing = Grasscutter.config.version;
        int latest = ConfigContainer.version();
        if (existing == latest) {
            return;
        }
        ConfigContainer updated = new ConfigContainer();
        Field[] fields = ConfigContainer.class.getDeclaredFields();
        Arrays.stream(fields).forEach(field -> {
            try {
                field.set(updated, field.get(Grasscutter.config));
            }
            catch (Exception exception) {
                Grasscutter.getLogger().error("Failed to update a configuration field.", exception);
            }
        });
        updated.version = ConfigContainer.version();
        try {
            Grasscutter.saveConfig(updated);
            Grasscutter.loadConfig();
        }
        catch (Exception exception) {
            Grasscutter.getLogger().warn("Failed to inject the updated ", exception);
        }
    }

    public static class Structure {
        public String resources = "./resources/";
        public String data = "./data/";
        public String packets = "./packets/";
        public String keys = "./keys/";
        public String scripts = "./resources/scripts/";
        public String plugins = "./plugins/";
    }

    public static class Database {
        public DataStore server = new DataStore();
        public DataStore game = new DataStore();

        public static class DataStore {
            public String connectionUri = "mongodb://localhost:27017";
            public String collection = "grasscutter";
        }
    }

    public static class Language {
        public Locale language = Locale.getDefault();
        public Locale fallback = Locale.US;
    }

    public static class Account {
        public boolean autoCreate = false;
        public String[] defaultPermissions = new String[0];
    }

    public static class Server {
        public Grasscutter.ServerDebugMode debugLevel = Grasscutter.ServerDebugMode.NONE;
        public Grasscutter.ServerRunMode runMode = Grasscutter.ServerRunMode.HYBRID;
        public HTTP http = new HTTP();
        public Game game = new Game();
        public Dispatch dispatch = new Dispatch();
    }

    public static class Region {
        public String Name = "os_usa";
        public String Title = "Grasscutter";
        public String Ip = "127.0.0.1";
        public int Port = 22102;

        public Region() {
        }

        public Region(String name, String title, String address, int port) {
            this.Name = name;
            this.Title = title;
            this.Ip = address;
            this.Port = port;
        }
    }

    public static class Files {
        public String indexFile = "./index.html";
        public String errorFile = "./404.html";
    }

    public static class ConsoleAccount {
        public int avatarId = 10000007;
        public int nameCardId = 210001;
        public int adventureRank = 1;
        public int worldLevel = 0;
        public String nickName = "Server";
        public String signature = "Welcome to Grasscutter!";
    }

    public static class JoinOptions {
        public int[] welcomeEmotes = new int[]{2007, 1002, 4010};
        public String welcomeMessage = "Welcome to a Grasscutter server.";
        public Mail welcomeMail = new Mail();

        public static class Mail {
            public String title = "Welcome to Grasscutter!";
            public String content = "Hi there!\r\nFirst of all, welcome to Grasscutter. If you have any issues, please let us know so that Lawnmower can help you! \r\n\r\nCheck out our:\r\n<type=\"browser\" text=\"Discord\" href=\"https://discord.gg/T5vZU6UyeG\"/>\n";
            public String sender = "Lawnmower";
            public Mail.MailItem[] items = new Mail.MailItem[]{new Mail.MailItem(13509, 1, 1), new Mail.MailItem(201, 99999, 1)};
        }
    }

    public static class GameOptions {
        public InventoryLimits inventoryLimits = new InventoryLimits();
        public AvatarLimits avatarLimits = new AvatarLimits();
        public int worldEntityLimit = 1000;
        public boolean watchGachaConfig = false;
        public boolean enableShopItems = true;
        public boolean staminaUsage = true;
        public Rates rates = new Rates();

        public static class InventoryLimits {
            public int weapons = 2000;
            public int relics = 2000;
            public int materials = 2000;
            public int furniture = 2000;
            public int all = 30000;
        }

        public static class AvatarLimits {
            public int singlePlayerTeam = 4;
            public int multiplayerTeam = 4;
        }

        public static class Rates {
            public float adventureExp = 1.0f;
            public float mora = 1.0f;
            public float leyLines = 1.0f;
        }
    }

    public static class Policies {
        public CORS cors = new CORS();

        public static class CORS {
            public boolean enabled = false;
            public String[] allowedOrigins = new String[]{"*"};
        }
    }

    public static class Encryption {
        public boolean useEncryption = true;
        public boolean useInRouting = true;
        public String keystore = "./keystore.p12";
        public String keystorePassword = "123456";
    }

    public static class Dispatch {
        public Region[] regions = new Region[0];
        public String defaultName = "Grasscutter";
    }

    public static class Game {
        public String bindAddress = "0.0.0.0";
        public String accessAddress = "127.0.0.1";
        public int bindPort = 22102;
        public int accessPort = 0;
        public GameOptions gameOptions = new GameOptions();
        public JoinOptions joinOptions = new JoinOptions();
        public ConsoleAccount serverAccount = new ConsoleAccount();
    }

    public static class HTTP {
        public String bindAddress = "0.0.0.0";
        public String accessAddress = "127.0.0.1";
        public int bindPort = 443;
        public int accessPort = 0;
        public Encryption encryption = new Encryption();
        public Policies policies = new Policies();
        public Files files = new Files();
    }
}

