/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.tools;

import com.google.gson.reflect.TypeToken;
import emu.grasscutter.Configuration;
import emu.grasscutter.GameConstants;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandMap;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.GameResource;
import emu.grasscutter.data.ResourceLoader;
import emu.grasscutter.data.custom.MainQuestData;
import emu.grasscutter.data.def.AvatarData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.data.def.MonsterData;
import emu.grasscutter.data.def.QuestData;
import emu.grasscutter.data.def.SceneData;
import emu.grasscutter.utils.Language;
import emu.grasscutter.utils.Utils;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

final class ToolsWithLanguageOption {
    ToolsWithLanguageOption() {
    }

    public static void createGmHandbook(String language) throws Exception {
        Map map;
        ResourceLoader.loadAll();
        try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(Utils.toFilePath(Configuration.RESOURCE("TextMap/TextMap" + language + ".json"))), StandardCharsets.UTF_8);){
            map = (Map)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, new TypeToken<Map<Long, String>>(){}.getType());
        }
        String fileName = "./GM Handbook.txt";
        try (PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8), false);){
            GameResource data;
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            writer.println("// Grasscutter " + GameConstants.VERSION + " GM Handbook");
            writer.println("// Created " + dtf.format(now) + System.lineSeparator() + System.lineSeparator());
            CommandMap cmdMap = new CommandMap(true);
            ArrayList<Command> cmdList = new ArrayList<Command>(cmdMap.getAnnotationsAsList());
            writer.println("// Commands");
            for (Command cmd : cmdList) {
                StringBuilder cmdName = new StringBuilder(cmd.label());
                while (cmdName.length() <= 15) {
                    cmdName.insert(0, " ");
                }
                writer.println(cmdName + " : " + Language.translate(cmd.description(), new Object[0]));
            }
            writer.println();
            ArrayList<Integer> list = new ArrayList<Integer>(GameData.getAvatarDataMap().keySet());
            Collections.sort(list);
            writer.println("// Avatars");
            for (Integer id : list) {
                data = GameData.getAvatarDataMap().get(id);
                writer.println(((AvatarData)data).getId() + " : " + (String)map.get(((AvatarData)data).getNameTextMapHash()));
            }
            writer.println();
            list = new ArrayList<Integer>(GameData.getItemDataMap().keySet());
            Collections.sort(list);
            writer.println("// Items");
            for (Integer id : list) {
                data = GameData.getItemDataMap().get(id);
                writer.println(((ItemData)data).getId() + " : " + (String)map.get(((ItemData)data).getNameTextMapHash()));
            }
            writer.println();
            writer.println("// Scenes");
            list = new ArrayList<Integer>(GameData.getSceneDataMap().keySet());
            Collections.sort(list);
            for (Integer id : list) {
                data = GameData.getSceneDataMap().get(id);
                writer.println(((SceneData)data).getId() + " : " + ((SceneData)data).getScriptData());
            }
            writer.println();
            writer.println("// Quests");
            list = new ArrayList<Integer>(GameData.getQuestDataMap().keySet());
            Collections.sort(list);
            for (Integer id : list) {
                data = GameData.getQuestDataMap().get(id);
                MainQuestData mainQuest = (MainQuestData)GameData.getMainQuestDataMap().get(((QuestData)data).getMainId());
                writer.println(((QuestData)data).getId() + " : " + (String)map.get(mainQuest.getTitleTextMapHash()) + " - " + (String)map.get(((QuestData)data).getDescTextMapHash()));
            }
            writer.println();
            writer.println("// Monsters");
            list = new ArrayList<Integer>(GameData.getMonsterDataMap().keySet());
            Collections.sort(list);
            for (Integer id : list) {
                data = GameData.getMonsterDataMap().get(id);
                writer.println(((MonsterData)data).getId() + " : " + (String)map.get(((MonsterData)data).getNameTextMapHash()));
            }
        }
        Grasscutter.getLogger().info("GM Handbook generated!");
    }

    public static void createGachaMapping(String location, String language) throws Exception {
        Map map;
        ResourceLoader.loadResources();
        try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(Utils.toFilePath(Configuration.RESOURCE("TextMap/TextMap" + language + ".json"))), StandardCharsets.UTF_8);){
            map = (Map)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, new TypeToken<Map<Long, String>>(){}.getType());
        }
        try (PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(location), StandardCharsets.UTF_8), false);){
            GameResource data;
            ArrayList<Integer> list = new ArrayList<Integer>(GameData.getAvatarDataMap().keySet());
            Collections.sort(list);
            writer.println("mappings = {\"en-us\": {");
            boolean first = true;
            for (Integer id : list) {
                data = GameData.getAvatarDataMap().get(id);
                int avatarID = ((AvatarData)data).getId();
                if (avatarID >= 11000000) continue;
                if (first) {
                    first = false;
                } else {
                    writer.print(",");
                }
                String color = switch (((AvatarData)data).getQualityType()) {
                    case "QUALITY_PURPLE" -> "purple";
                    case "QUALITY_ORANGE" -> "yellow";
                    default -> "blue";
                };
                writer.println("\"" + (avatarID % 1000 + 1000) + "\" : [\"" + (String)map.get(((AvatarData)data).getNameTextMapHash()) + "(" + (String)map.get(4233146695L) + ")\", \"" + color + "\"]");
            }
            writer.println();
            list = new ArrayList<Integer>(GameData.getItemDataMap().keySet());
            Collections.sort(list);
            block24: for (Integer id : list) {
                String color;
                data = GameData.getItemDataMap().get(id);
                if (((ItemData)data).getId() <= 11101 || ((ItemData)data).getId() >= 20000) continue;
                switch (((ItemData)data).getRankLevel()) {
                    case 3: {
                        color = "blue";
                        break;
                    }
                    case 4: {
                        color = "purple";
                        break;
                    }
                    case 5: {
                        color = "yellow";
                        break;
                    }
                    default: {
                        continue block24;
                    }
                }
                writer.println(",\"" + ((ItemData)data).getId() + "\" : [\"" + ((String)map.get(((ItemData)data).getNameTextMapHash())).replaceAll("\"", "") + "(" + (String)map.get(4231343903L) + ")\",\"" + color + "\"]");
            }
            writer.println(",\"200\": \"" + (String)map.get(332935371L) + "\", \"301\": \"" + (String)map.get(2272170627L) + "\", \"302\": \"" + (String)map.get(2864268523L) + "\"");
            writer.println("}\n}");
        }
        Grasscutter.getLogger().info("Mappings generated to " + location + " !");
    }
}

