/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.task;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.task.Task;
import emu.grasscutter.task.TaskHandler;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.reflections.Reflections;

public final class TaskMap {
    private final Map<String, TaskHandler> tasks = new HashMap<String, TaskHandler>();
    private final Map<String, Task> annotations = new HashMap<String, Task>();
    private final Map<String, TaskHandler> afterReset = new HashMap<String, TaskHandler>();
    private final SchedulerFactory schedulerFactory = new StdSchedulerFactory();

    public TaskMap() {
        this(false);
    }

    public TaskMap(boolean scan2) {
        if (scan2) {
            this.scan();
        }
    }

    public static TaskMap getInstance() {
        return Grasscutter.getGameServer().getTaskMap();
    }

    public void resetNow() {
        for (TaskHandler task : this.tasks.values()) {
            this.unregisterTask(task);
        }
        for (TaskHandler task : this.afterReset.values()) {
            try {
                task.restartExecute();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.afterReset.clear();
        for (TaskHandler task : this.tasks.values()) {
            this.registerTask(task.getClass().getAnnotation(Task.class).taskName(), task);
        }
    }

    public TaskMap unregisterTask(TaskHandler task) {
        this.tasks.remove(task.getClass().getAnnotation(Task.class).taskName());
        this.annotations.remove(task.getClass().getAnnotation(Task.class).taskName());
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            scheduler.deleteJob(new JobKey(task.getClass().getAnnotation(Task.class).taskName()));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        task.onDisable();
        return this;
    }

    public boolean pauseTask(String taskName) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            scheduler.pauseJob(new JobKey(taskName));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean resumeTask(String taskName) {
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            scheduler.resumeJob(new JobKey(taskName));
        }
        catch (SchedulerException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean cancelTask(String taskName) {
        Task task = this.annotations.get(taskName);
        if (task == null) {
            return false;
        }
        try {
            this.unregisterTask(this.tasks.get(taskName));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public TaskMap registerTask(String taskName, TaskHandler task) {
        Task annotation = task.getClass().getAnnotation(Task.class);
        this.annotations.put(taskName, annotation);
        this.tasks.put(taskName, task);
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            JobDetail job = JobBuilder.newJob(task.getClass()).withIdentity(taskName).build();
            CronTrigger convTrigger = TriggerBuilder.newTrigger().withIdentity(annotation.triggerName()).withSchedule(CronScheduleBuilder.cronSchedule(annotation.taskCronExpression())).build();
            scheduler.scheduleJob(job, convTrigger);
            if (annotation.executeImmediately()) {
                task.execute(null);
            }
            task.onEnable();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
        return this;
    }

    public List<TaskHandler> getHandlersAsList() {
        return new LinkedList<TaskHandler>(this.tasks.values());
    }

    public HashMap<String, TaskHandler> getHandlers() {
        return new LinkedHashMap<String, TaskHandler>(this.tasks);
    }

    public TaskHandler getHandler(String taskName) {
        return this.tasks.get(taskName);
    }

    private void scan() {
        Reflections reflector = Grasscutter.reflector;
        Set<Class<?>> classes = reflector.getTypesAnnotatedWith(Task.class);
        classes.forEach(annotated -> {
            try {
                Task taskData = annotated.getAnnotation(Task.class);
                Object object = annotated.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (object instanceof TaskHandler) {
                    this.registerTask(taskData.taskName(), (TaskHandler)object);
                    if (taskData.executeImmediatelyAfterReset()) {
                        this.afterReset.put(taskData.taskName(), (TaskHandler)object);
                    }
                } else {
                    Grasscutter.getLogger().error("Class " + annotated.getName() + " is not a TaskHandler!");
                }
            }
            catch (Exception exception) {
                Grasscutter.getLogger().error("Failed to register task handler for " + annotated.getSimpleName(), exception);
            }
        });
        try {
            Scheduler scheduler = this.schedulerFactory.getScheduler();
            scheduler.start();
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }
}

