/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.send;

import com.google.protobuf.ByteString;
import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.PlayerLoginRspOuterClass;
import emu.grasscutter.net.proto.QueryCurrRegionHttpRspOuterClass;
import emu.grasscutter.net.proto.RegionInfoOuterClass;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.http.dispatch.RegionHandler;
import emu.grasscutter.utils.Crypto;
import java.util.Objects;

public class PacketPlayerLoginRsp
extends BasePacket {
    private static QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp regionCache;

    public PacketPlayerLoginRsp(GameSession session) {
        super(115, 1);
        RegionInfoOuterClass.RegionInfo info;
        this.setUseDispatchKey(true);
        if (Configuration.SERVER.runMode == Grasscutter.ServerRunMode.GAME_ONLY) {
            if (regionCache == null) {
                try {
                    RegionInfoOuterClass.RegionInfo serverRegion = RegionInfoOuterClass.RegionInfo.newBuilder().setGateserverIp(Configuration.lr(Configuration.GAME_INFO.accessAddress, Configuration.GAME_INFO.bindAddress)).setGateserverPort(Configuration.lr(Configuration.GAME_INFO.accessPort, Configuration.GAME_INFO.bindPort)).setSecretKey(ByteString.copyFrom(Crypto.DISPATCH_SEED)).build();
                    regionCache = QueryCurrRegionHttpRspOuterClass.QueryCurrRegionHttpRsp.newBuilder().setRegionInfo(serverRegion).build();
                }
                catch (Exception e) {
                    Grasscutter.getLogger().error("Error while initializing region cache!", e);
                }
            }
            info = regionCache.getRegionInfo();
        } else {
            info = Objects.requireNonNull(RegionHandler.getCurrentRegion()).getRegionInfo();
        }
        PlayerLoginRspOuterClass.PlayerLoginRsp p = PlayerLoginRspOuterClass.PlayerLoginRsp.newBuilder().setIsUseAbilityHash(true).setAbilityHashCode(1844674).setGameBiz("hk4e_global").setClientDataVersion(info.getClientDataVersion()).setClientSilenceDataVersion(info.getClientSilenceDataVersion()).setClientMd5(info.getClientDataMd5()).setClientSilenceMd5(info.getClientSilenceDataMd5()).setResVersionConfig(info.getResVersionConfig()).setClientVersionSuffix(info.getClientVersionSuffix()).setClientSilenceVersionSuffix(info.getClientSilenceVersionSuffix()).setIsScOpen(false).setRegisterCps("mihoyo").setCountryCode("US").build();
        this.setData(p.toByteArray());
    }
}

