/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.send;

import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.ItemParamOuterClass;
import emu.grasscutter.net.proto.MailChangeNotifyOuterClass;
import emu.grasscutter.net.proto.MailDataOuterClass;
import emu.grasscutter.net.proto.MailItemOuterClass;
import emu.grasscutter.net.proto.MailTextContentOuterClass;
import java.util.ArrayList;
import java.util.List;

public class PacketMailChangeNotify
extends BasePacket {
    public PacketMailChangeNotify(Player player, final Mail message) {
        this(player, (List<Mail>)new ArrayList<Mail>(){
            {
                this.add(message);
            }
        });
    }

    public PacketMailChangeNotify(Player player, List<Mail> mailList) {
        this(player, mailList, null);
    }

    public PacketMailChangeNotify(Player player, List<Mail> mailList, List<Integer> delMailIdList) {
        super(1433);
        MailChangeNotifyOuterClass.MailChangeNotify.Builder proto = MailChangeNotifyOuterClass.MailChangeNotify.newBuilder();
        if (mailList != null) {
            for (Mail message : mailList) {
                MailTextContentOuterClass.MailTextContent.Builder mailTextContent = MailTextContentOuterClass.MailTextContent.newBuilder();
                mailTextContent.setTitle(message.mailContent.title);
                mailTextContent.setContent(message.mailContent.content);
                mailTextContent.setSender(message.mailContent.sender);
                ArrayList<MailItemOuterClass.MailItem> mailItems = new ArrayList<MailItemOuterClass.MailItem>();
                for (Mail.MailItem item : message.itemList) {
                    MailItemOuterClass.MailItem.Builder mailItem = MailItemOuterClass.MailItem.newBuilder();
                    ItemParamOuterClass.ItemParam.Builder itemParam = ItemParamOuterClass.ItemParam.newBuilder();
                    itemParam.setItemId(item.itemId);
                    itemParam.setCount(item.itemCount);
                    mailItem.setItemParam(itemParam.build());
                    mailItems.add(mailItem.build());
                }
                MailDataOuterClass.MailData.Builder mailData = MailDataOuterClass.MailData.newBuilder();
                mailData.setMailId(player.getMailId(message));
                mailData.setMailTextContent(mailTextContent.build());
                mailData.addAllItemList(mailItems);
                mailData.setSendTime((int)message.sendTime);
                mailData.setExpireTime((int)message.expireTime);
                mailData.setImportance(message.importance);
                mailData.setIsRead(message.isRead);
                mailData.setIsAttachmentGot(message.isAttachmentGot);
                mailData.setStateValue(message.stateValue);
                proto.addMailList(mailData.build());
            }
        }
        if (delMailIdList != null) {
            proto.addAllDelMailIdList(delMailIdList);
        }
        this.setData(proto.build());
    }
}

