/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.send;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.EquipParamOuterClass;
import emu.grasscutter.net.proto.GetMailItemRspOuterClass;
import emu.grasscutter.server.packet.send.PacketMailChangeNotify;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PacketGetMailItemRsp
extends BasePacket {
    public PacketGetMailItemRsp(Player player, List<Integer> mailList) {
        super(1437);
        ArrayList<Mail> claimedMessages = new ArrayList<Mail>();
        ArrayList<EquipParamOuterClass.EquipParam> claimedItems = new ArrayList<EquipParamOuterClass.EquipParam>();
        GetMailItemRspOuterClass.GetMailItemRsp.Builder proto = GetMailItemRspOuterClass.GetMailItemRsp.newBuilder();
        for (int mailId : mailList) {
            Mail message2 = player.getMail(mailId);
            for (Mail.MailItem mailItem : message2.itemList) {
                EquipParamOuterClass.EquipParam.Builder item = EquipParamOuterClass.EquipParam.newBuilder();
                int promoteLevel = 0;
                if (mailItem.itemLevel > 20) {
                    promoteLevel = 1;
                } else if (mailItem.itemLevel > 40) {
                    promoteLevel = 2;
                } else if (mailItem.itemLevel > 50) {
                    promoteLevel = 3;
                } else if (mailItem.itemLevel > 60) {
                    promoteLevel = 4;
                } else if (mailItem.itemLevel > 70) {
                    promoteLevel = 5;
                } else if (mailItem.itemLevel > 80) {
                    promoteLevel = 6;
                }
                item.setItemId(mailItem.itemId);
                item.setItemNum(mailItem.itemCount);
                item.setItemLevel(mailItem.itemLevel);
                item.setPromoteLevel(promoteLevel);
                claimedItems.add(item.build());
                GameItem gameItem = new GameItem((ItemData)GameData.getItemDataMap().get(mailItem.itemId));
                gameItem.setCount(mailItem.itemCount);
                gameItem.setLevel(mailItem.itemLevel);
                gameItem.setPromoteLevel(promoteLevel);
                player.getInventory().addItem(gameItem, ActionReason.MailAttachment);
            }
            message2.isAttachmentGot = true;
            claimedMessages.add(message2);
            player.replaceMailByIndex(mailId, message2);
        }
        proto.addAllMailIdList(claimedMessages.stream().map(message -> player.getMailId((Mail)message)).collect(Collectors.toList()));
        proto.addAllItemList(claimedItems);
        this.setData(proto.build());
        player.getSession().send(new PacketMailChangeNotify(player, claimedMessages));
    }
}

