/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.send;

import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.GetAllMailRspOuterClass;
import emu.grasscutter.net.proto.ItemParamOuterClass;
import emu.grasscutter.net.proto.MailDataOuterClass;
import emu.grasscutter.net.proto.MailItemOuterClass;
import emu.grasscutter.net.proto.MailTextContentOuterClass;
import java.time.Instant;
import java.util.ArrayList;

public class PacketGetAllMailRsp
extends BasePacket {
    public PacketGetAllMailRsp(Player player, boolean isGiftMail) {
        super(1491);
        GetAllMailRspOuterClass.GetAllMailRsp.Builder proto = GetAllMailRspOuterClass.GetAllMailRsp.newBuilder();
        if (isGiftMail) {
            proto.setIsGiftMail(true);
        } else {
            proto.setIsGiftMail(false);
            if (player.getAllMail().size() != 0) {
                ArrayList<MailDataOuterClass.MailData> mailDataList = new ArrayList<MailDataOuterClass.MailData>();
                for (Mail message : player.getAllMail()) {
                    if (message.stateValue != 1 || message.expireTime <= (long)((int)Instant.now().getEpochSecond()) || mailDataList.size() > 1000) continue;
                    MailTextContentOuterClass.MailTextContent.Builder mailTextContent = MailTextContentOuterClass.MailTextContent.newBuilder();
                    mailTextContent.setTitle(message.mailContent.title);
                    mailTextContent.setContent(message.mailContent.content);
                    mailTextContent.setSender(message.mailContent.sender);
                    ArrayList<MailItemOuterClass.MailItem> mailItems = new ArrayList<MailItemOuterClass.MailItem>();
                    for (Mail.MailItem item : message.itemList) {
                        MailItemOuterClass.MailItem.Builder mailItem = MailItemOuterClass.MailItem.newBuilder();
                        ItemParamOuterClass.ItemParam.Builder itemParam = ItemParamOuterClass.ItemParam.newBuilder();
                        itemParam.setItemId(item.itemId);
                        itemParam.setCount(item.itemCount);
                        mailItem.setItemParam(itemParam.build());
                        mailItems.add(mailItem.build());
                    }
                    MailDataOuterClass.MailData.Builder mailData = MailDataOuterClass.MailData.newBuilder();
                    mailData.setMailId(player.getMailId(message));
                    mailData.setMailTextContent(mailTextContent.build());
                    mailData.addAllItemList(mailItems);
                    mailData.setSendTime((int)message.sendTime);
                    mailData.setExpireTime((int)message.expireTime);
                    mailData.setImportance(message.importance);
                    mailData.setIsRead(message.isRead);
                    mailData.setIsAttachmentGot(message.isAttachmentGot);
                    mailData.setStateValue(1);
                    mailDataList.add(mailData.build());
                }
                proto.addAllMailList(mailDataList);
                proto.setIsTruncated(mailDataList.size() > 1000);
            }
        }
        this.setData(proto.build());
    }
}

