/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.GadgetData;
import emu.grasscutter.game.entity.EntityVehicle;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.WidgetDoBagReqOuterClass;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.packet.send.PacketWidgetCoolDownNotify;
import emu.grasscutter.server.packet.send.PacketWidgetDoBagRsp;
import emu.grasscutter.server.packet.send.PacketWidgetGadgetDataNotify;
import emu.grasscutter.utils.Position;
import java.util.List;

@Opcodes(value=4269)
public class HandlerWidgetDoBagReq
extends PacketHandler {
    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        WidgetDoBagReqOuterClass.WidgetDoBagReq req = WidgetDoBagReqOuterClass.WidgetDoBagReq.parseFrom(payload);
        switch (req.getMaterialId()) {
            case 220026: {
                GadgetData gadgetData = (GadgetData)GameData.getGadgetDataMap().get(70500025);
                Position pos = new Position(req.getWidgetCreatorInfo().getLocationInfo().getPos());
                Position rot = new Position(req.getWidgetCreatorInfo().getLocationInfo().getRot());
                EntityVehicle entity = new EntityVehicle(session.getPlayer().getScene(), session.getPlayer(), gadgetData.getId(), 0, pos, rot);
                session.getPlayer().getScene().addEntity(entity);
                session.send(new PacketWidgetGadgetDataNotify(70500025, List.of(Integer.valueOf(entity.getId()))));
                session.send(new PacketWidgetCoolDownNotify(15, System.currentTimeMillis() + 5000L, true));
                session.send(new PacketWidgetCoolDownNotify(15, System.currentTimeMillis() + 5000L, true));
                session.send(new PacketWidgetDoBagRsp());
                break;
            }
            default: {
                session.send(new PacketWidgetDoBagRsp());
            }
        }
    }
}

