/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.common.ItemParamData;
import emu.grasscutter.data.def.PlayerLevelData;
import emu.grasscutter.data.def.RewardData;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.TakePlayerLevelRewardReqOuterClass;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.packet.send.PacketTakePlayerLevelRewardRsp;
import java.util.List;
import java.util.Set;

@Opcodes(value=151)
public class HandlerTakePlayerLevelRewardReq
extends PacketHandler {
    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        TakePlayerLevelRewardReqOuterClass.TakePlayerLevelRewardReq req = TakePlayerLevelRewardReqOuterClass.TakePlayerLevelRewardReq.parseFrom(payload);
        int level = req.getLevel();
        int rewardId = ((PlayerLevelData)GameData.getPlayerLevelDataMap().get(level)).getRewardId();
        if (rewardId != 0) {
            List<ItemParamData> rewardItems = ((RewardData)GameData.getRewardDataMap().get(rewardId)).getRewardItemList();
            session.getPlayer().getInventory().addItemParamDatas(rewardItems, ActionReason.PlayerUpgradeReward);
            Set<Integer> rewardedLevels = session.getPlayer().getRewardedLevels();
            rewardedLevels.add(level);
            session.getPlayer().setRewardedLevels(rewardedLevels);
        }
        session.send(new PacketTakePlayerLevelRewardRsp(level, rewardId));
    }
}

