/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.packet.recv;

import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.commands.SendMailCommand;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.AvatarSkillDepotData;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.packet.Opcodes;
import emu.grasscutter.net.packet.PacketHandler;
import emu.grasscutter.net.proto.SetPlayerBornDataReqOuterClass;
import emu.grasscutter.server.event.game.PlayerCreationEvent;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.utils.ConfigContainer;
import java.util.Arrays;

@Opcodes(value=155)
public class HandlerSetPlayerBornDataReq
extends PacketHandler {
    @Override
    public void handle(GameSession session, byte[] header, byte[] payload) throws Exception {
        int startingSkillDepot;
        SetPlayerBornDataReqOuterClass.SetPlayerBornDataReq req = SetPlayerBornDataReqOuterClass.SetPlayerBornDataReq.parseFrom(payload);
        int avatarId = req.getAvatarId();
        if (avatarId == 10000005) {
            startingSkillDepot = 504;
        } else if (avatarId == 10000007) {
            startingSkillDepot = 704;
        } else {
            return;
        }
        if (!GameData.getAvatarDataMap().containsKey(avatarId)) {
            Grasscutter.getLogger().error("No avatar data found! Please check your ExcelBinOutput folder.");
            session.close();
            return;
        }
        String nickname = req.getNickName();
        if (nickname == null) {
            nickname = "Traveler";
        }
        PlayerCreationEvent event = new PlayerCreationEvent(session, Player.class);
        event.call();
        Player player = event.getPlayerClass().getDeclaredConstructor(GameSession.class).newInstance(session);
        player.setNickname(nickname);
        try {
            DatabaseHelper.createPlayer(player, session.getAccount().getPlayerUid());
            if (player.getAvatars().getAvatarCount() == 0) {
                Avatar mainCharacter = new Avatar(avatarId);
                mainCharacter.setSkillDepotData((AvatarSkillDepotData)GameData.getAvatarSkillDepotDataMap().get(startingSkillDepot));
                player.addAvatar(mainCharacter);
                player.setMainCharacterId(avatarId);
                player.setHeadImage(avatarId);
                player.getTeamManager().getCurrentSinglePlayerTeamInfo().getAvatars().add(mainCharacter.getAvatarId());
                player.save();
            }
            session.getAccount().setPlayerId(player.getUid());
            session.getAccount().save();
            session.setPlayer(player);
            session.getPlayer().onLogin();
            session.setState(GameSession.SessionState.ACTIVE);
            session.send(new BasePacket(146));
            ConfigContainer.JoinOptions.Mail welcomeMail = Configuration.GAME_INFO.joinOptions.welcomeMail;
            SendMailCommand.MailBuilder mailBuilder = new SendMailCommand.MailBuilder(player.getUid(), new Mail());
            mailBuilder.mail.mailContent.title = welcomeMail.title;
            mailBuilder.mail.mailContent.sender = welcomeMail.sender;
            mailBuilder.mail.mailContent.content = welcomeMail.content + "\n<type=\"browser\" text=\"GitHub\" href=\"https://github.com/Melledy/Grasscutter\"/>";
            mailBuilder.mail.itemList.addAll(Arrays.asList(welcomeMail.items));
            mailBuilder.mail.importance = 1;
            player.sendMail(mailBuilder.mail);
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Error creating player object: ", e);
            session.close();
        }
    }
}

