/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.server.http;

import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.server.http.Router;
import emu.grasscutter.utils.FileUtils;
import emu.grasscutter.utils.Language;
import express.Express;
import express.http.MediaType;
import io.javalin.Javalin;
import java.io.File;
import java.lang.reflect.Constructor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public final class HttpServer {
    private final Express express = new Express(config -> {
        config.server(HttpServer::createServer);
        config.enforceSsl = Configuration.HTTP_ENCRYPTION.useEncryption;
        if (Configuration.HTTP_POLICIES.cors.enabled) {
            String[] allowedOrigins = Configuration.HTTP_POLICIES.cors.allowedOrigins;
            if (allowedOrigins.length > 0) {
                config.enableCorsForOrigin(allowedOrigins);
            } else {
                config.enableCorsForAllOrigins();
            }
        }
        if (Configuration.SERVER.debugLevel == Grasscutter.ServerDebugMode.ALL) {
            config.enableDevLogging();
        }
        config.precompressStaticFiles = false;
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Server createServer() {
        Server server = new Server();
        ServerConnector serverConnector = new ServerConnector(server);
        if (Configuration.HTTP_ENCRYPTION.useEncryption) {
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            File keystoreFile = new File(Configuration.HTTP_ENCRYPTION.keystore);
            if (!keystoreFile.exists()) {
                Configuration.HTTP_ENCRYPTION.useEncryption = false;
                Configuration.HTTP_ENCRYPTION.useInRouting = false;
                Grasscutter.getLogger().warn(Language.translate("messages.dispatch.keystore.no_keystore_error", new Object[0]));
            } else {
                try {
                    sslContextFactory.setKeyStorePath(keystoreFile.getPath());
                    sslContextFactory.setKeyStorePassword(Configuration.HTTP_ENCRYPTION.keystorePassword);
                }
                catch (Exception ignored) {
                    Grasscutter.getLogger().warn(Language.translate("messages.dispatch.keystore.password_error", new Object[0]));
                    try {
                        sslContextFactory.setKeyStorePath(keystoreFile.getPath());
                        sslContextFactory.setKeyStorePassword("123456");
                        Grasscutter.getLogger().warn(Language.translate("messages.dispatch.keystore.default_password", new Object[0]));
                    }
                    catch (Exception exception) {
                        Grasscutter.getLogger().warn(Language.translate("messages.dispatch.keystore.general_error", new Object[0]), exception);
                    }
                }
                finally {
                    serverConnector = new ServerConnector(server, sslContextFactory);
                }
            }
        }
        serverConnector.setPort(Configuration.HTTP_INFO.bindPort);
        server.setConnectors(new ServerConnector[]{serverConnector});
        return server;
    }

    public Javalin getHandle() {
        return this.express.raw();
    }

    public HttpServer addRouter(Class<? extends Router> router, Object ... args2) {
        Class[] types = new Class[args2.length];
        for (Object argument : args2) {
            types[args2.length - 1] = argument.getClass();
        }
        try {
            Constructor<? extends Router> constructor = router.getDeclaredConstructor(types);
            Router routerInstance = constructor.newInstance(args2);
            routerInstance.applyRoutes(this.express, this.getHandle());
        }
        catch (Exception exception) {
            Grasscutter.getLogger().warn(Language.translate("messages.dispatch.router_error", new Object[0]), exception);
        }
        return this;
    }

    public void start() {
        this.express.listen(Configuration.HTTP_INFO.bindAddress, Configuration.HTTP_INFO.bindPort);
        Grasscutter.getLogger().info(Language.translate("messages.dispatch.port_bind", Integer.toString(this.express.raw().port())));
    }

    public static class UnhandledRequestRouter
    implements Router {
        @Override
        public void applyRoutes(Express express, Javalin handle2) {
            handle2.error(404, context -> {
                if (Configuration.SERVER.debugLevel == Grasscutter.ServerDebugMode.MISSING) {
                    Grasscutter.getLogger().info(Language.translate("messages.dispatch.unhandled_request_error", context.method(), context.url()));
                }
                context.contentType("text/html");
                File file = new File(Configuration.HTTP_STATIC_FILES.errorFile);
                if (!file.exists()) {
                    context.result("<!DOCTYPE html>\n<html>\n    <head>\n        <meta charset=\"utf8\">\n    </head>\n\n    <body>\n        <img src=\"https://http.cat/404\" />\n    </body>\n</html>\n");
                } else {
                    String filePath = file.getPath();
                    MediaType fromExtension = MediaType.getByExtension(filePath.substring(filePath.lastIndexOf(".") + 1));
                    context.contentType(fromExtension != null ? fromExtension.getMIME() : "text/plain").result(FileUtils.read(filePath));
                }
            });
        }
    }

    public static class DefaultRequestRouter
    implements Router {
        @Override
        public void applyRoutes(Express express, Javalin handle2) {
            express.get("/", (request, response) -> {
                File file = new File(Configuration.HTTP_STATIC_FILES.errorFile);
                if (!file.exists()) {
                    response.send("<!DOCTYPE html>\n<html>\n    <head>\n        <meta charset=\"utf8\">\n    </head>\n    <body>%s</body>\n</html>\n".formatted(Language.translate("messages.status.welcome", new Object[0])));
                } else {
                    String filePath = file.getPath();
                    MediaType fromExtension = MediaType.getByExtension(filePath.substring(filePath.lastIndexOf(".") + 1));
                    response.type(fromExtension != null ? fromExtension.getMIME() : "text/plain").send(FileUtils.read(filePath));
                }
            });
        }
    }
}

