/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.plugin.api;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.auth.AuthenticationSystem;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.server.http.HttpServer;
import emu.grasscutter.server.http.Router;
import java.util.LinkedList;
import java.util.List;

public final class ServerHook {
    private static ServerHook instance;
    private final GameServer gameServer;
    private final HttpServer httpServer;

    public static ServerHook getInstance() {
        return instance;
    }

    public ServerHook(GameServer gameServer, HttpServer httpServer) {
        this.gameServer = gameServer;
        this.httpServer = httpServer;
        instance = this;
    }

    public GameServer getGameServer() {
        return this.gameServer;
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public List<Player> getOnlinePlayers() {
        return new LinkedList<Player>(this.gameServer.getPlayers().values());
    }

    public void registerCommand(CommandHandler handler) {
        Class<?> clazz = handler.getClass();
        if (!clazz.isAnnotationPresent(Command.class)) {
            throw new IllegalArgumentException("Command handler must be annotated with @Command.");
        }
        Command commandData = clazz.getAnnotation(Command.class);
        this.gameServer.getCommandMap().registerCommand(commandData.label(), handler);
    }

    public void addRouter(Router router) {
        this.addRouter(router.getClass());
    }

    public void addRouter(Class<? extends Router> router) {
        this.httpServer.addRouter(router, new Object[0]);
    }

    public void setAuthSystem(AuthenticationSystem authSystem) {
        Grasscutter.setAuthenticationSystem(authSystem);
    }
}

