/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.plugin.api;

import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.entity.EntityAvatar;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.EnterReason;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.EnterTypeOuterClass;
import emu.grasscutter.server.packet.send.PacketAvatarFightPropUpdateNotify;
import emu.grasscutter.server.packet.send.PacketAvatarLifeStateChangeNotify;
import emu.grasscutter.server.packet.send.PacketPlayerEnterSceneNotify;
import emu.grasscutter.utils.Position;

public final class PlayerHook {
    private final Player player;

    public PlayerHook(Player player) {
        this.player = player;
    }

    public void kick() {
        this.player.getSession().close();
    }

    public void changeScenes(int sceneId) {
        this.player.getWorld().transferPlayerToScene(this.player, sceneId, this.player.getPos());
    }

    public void updateFightProperty(FightProperty property) {
        this.broadcastPacketToWorld(new PacketAvatarFightPropUpdateNotify(this.getCurrentAvatar(), property));
    }

    public void broadcastPacketToWorld(BasePacket packet) {
        this.player.getWorld().broadcastPacket(packet);
    }

    public void setHealth(float health) {
        this.getCurrentAvatarEntity().setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, health);
        this.updateFightProperty(FightProperty.FIGHT_PROP_CUR_HP);
    }

    public void reviveAvatar(Avatar avatar) {
        this.broadcastPacketToWorld(new PacketAvatarLifeStateChangeNotify(avatar));
    }

    public void teleport(Position position) {
        this.player.getPos().set(position);
        this.player.sendPacket(new PacketPlayerEnterSceneNotify(this.player, EnterTypeOuterClass.EnterType.ENTER_JUMP, EnterReason.TransPoint, this.player.getSceneId(), position));
    }

    public float getMaxHealth() {
        return this.getCurrentAvatarEntity().getFightProperty(FightProperty.FIGHT_PROP_MAX_HP);
    }

    public EntityAvatar getCurrentAvatarEntity() {
        return this.player.getTeamManager().getCurrentAvatarEntity();
    }

    public Avatar getCurrentAvatar() {
        return this.getCurrentAvatarEntity().getAvatar();
    }
}

