/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.world;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.GameDepot;
import emu.grasscutter.data.def.DungeonData;
import emu.grasscutter.data.def.MonsterData;
import emu.grasscutter.data.def.SceneData;
import emu.grasscutter.data.def.WorldLevelData;
import emu.grasscutter.game.dungeons.DungeonChallenge;
import emu.grasscutter.game.dungeons.DungeonSettleListener;
import emu.grasscutter.game.entity.EntityAvatar;
import emu.grasscutter.game.entity.EntityBaseGadget;
import emu.grasscutter.game.entity.EntityClientGadget;
import emu.grasscutter.game.entity.EntityMonster;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.player.TeamInfo;
import emu.grasscutter.game.props.ClimateType;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.game.props.LifeState;
import emu.grasscutter.game.props.SceneType;
import emu.grasscutter.game.world.SpawnDataEntry;
import emu.grasscutter.game.world.World;
import emu.grasscutter.net.packet.BasePacket;
import emu.grasscutter.net.proto.AttackResultOuterClass;
import emu.grasscutter.net.proto.VisionTypeOuterClass;
import emu.grasscutter.scripts.SceneScriptManager;
import emu.grasscutter.scripts.data.SceneBlock;
import emu.grasscutter.scripts.data.SceneGroup;
import emu.grasscutter.server.packet.send.PacketAvatarSkillInfoNotify;
import emu.grasscutter.server.packet.send.PacketDungeonChallengeFinishNotify;
import emu.grasscutter.server.packet.send.PacketLifeStateChangeNotify;
import emu.grasscutter.server.packet.send.PacketSceneEntityAppearNotify;
import emu.grasscutter.server.packet.send.PacketSceneEntityDisappearNotify;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.danilopianini.util.SpatialIndex;

public class Scene {
    private final World world;
    private final SceneData sceneData;
    private final List<Player> players;
    private final Int2ObjectMap<GameEntity> entities;
    private final Set<SpawnDataEntry> spawnedEntities;
    private final Set<SpawnDataEntry> deadSpawnedEntities;
    private final Set<SceneBlock> loadedBlocks;
    private boolean dontDestroyWhenEmpty;
    private int autoCloseTime;
    private int time;
    private ClimateType climate;
    private int weather;
    private SceneScriptManager scriptManager;
    private DungeonChallenge challenge;
    private List<DungeonSettleListener> dungeonSettleListeners;
    private DungeonData dungeonData;
    private int prevScene;
    private int prevScenePoint;

    public Scene(World world, SceneData sceneData) {
        this.world = world;
        this.sceneData = sceneData;
        this.players = Collections.synchronizedList(new ArrayList());
        this.entities = Int2ObjectMaps.synchronize(new Int2ObjectOpenHashMap());
        this.time = 480;
        this.climate = ClimateType.CLIMATE_SUNNY;
        this.prevScene = 3;
        this.spawnedEntities = new HashSet<SpawnDataEntry>();
        this.deadSpawnedEntities = new HashSet<SpawnDataEntry>();
        this.loadedBlocks = new HashSet<SceneBlock>();
        this.scriptManager = new SceneScriptManager(this);
    }

    public int getId() {
        return this.sceneData.getId();
    }

    public World getWorld() {
        return this.world;
    }

    public SceneData getSceneData() {
        return this.sceneData;
    }

    public SceneType getSceneType() {
        return this.getSceneData().getSceneType();
    }

    public List<Player> getPlayers() {
        return this.players;
    }

    public int getPlayerCount() {
        return this.getPlayers().size();
    }

    public Int2ObjectMap<GameEntity> getEntities() {
        return this.entities;
    }

    public GameEntity getEntityById(int id) {
        return (GameEntity)this.entities.get(id);
    }

    public GameEntity getEntityByConfigId(int configId) {
        return this.entities.values().stream().filter(x -> x.getConfigId() == configId).findFirst().orElse(null);
    }

    public int getAutoCloseTime() {
        return this.autoCloseTime;
    }

    public void setAutoCloseTime(int autoCloseTime) {
        this.autoCloseTime = autoCloseTime;
    }

    public int getTime() {
        return this.time;
    }

    public void changeTime(int time) {
        this.time = time % 1440;
    }

    public ClimateType getClimate() {
        return this.climate;
    }

    public int getWeather() {
        return this.weather;
    }

    public void setClimate(ClimateType climate) {
        this.climate = climate;
    }

    public void setWeather(int weather) {
        this.weather = weather;
    }

    public int getPrevScene() {
        return this.prevScene;
    }

    public void setPrevScene(int prevScene) {
        this.prevScene = prevScene;
    }

    public int getPrevScenePoint() {
        return this.prevScenePoint;
    }

    public void setPrevScenePoint(int prevPoint) {
        this.prevScenePoint = prevPoint;
    }

    public boolean dontDestroyWhenEmpty() {
        return this.dontDestroyWhenEmpty;
    }

    public void setDontDestroyWhenEmpty(boolean dontDestroyWhenEmpty) {
        this.dontDestroyWhenEmpty = dontDestroyWhenEmpty;
    }

    public Set<SceneBlock> getLoadedBlocks() {
        return this.loadedBlocks;
    }

    public Set<SpawnDataEntry> getSpawnedEntities() {
        return this.spawnedEntities;
    }

    public Set<SpawnDataEntry> getDeadSpawnedEntities() {
        return this.deadSpawnedEntities;
    }

    public SceneScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public DungeonData getDungeonData() {
        return this.dungeonData;
    }

    public void setDungeonData(DungeonData dungeonData) {
        if (dungeonData == null || this.dungeonData != null || this.getSceneType() != SceneType.SCENE_DUNGEON || dungeonData.getSceneId() != this.getId()) {
            return;
        }
        this.dungeonData = dungeonData;
    }

    public DungeonChallenge getChallenge() {
        return this.challenge;
    }

    public void setChallenge(DungeonChallenge challenge) {
        this.challenge = challenge;
    }

    public void addDungeonSettleObserver(DungeonSettleListener dungeonSettleListener) {
        if (this.dungeonSettleListeners == null) {
            this.dungeonSettleListeners = new ArrayList<DungeonSettleListener>();
        }
        this.dungeonSettleListeners.add(dungeonSettleListener);
    }

    public List<DungeonSettleListener> getDungeonSettleObservers() {
        return this.dungeonSettleListeners;
    }

    public boolean isInScene(GameEntity entity) {
        return this.entities.containsKey(entity.getId());
    }

    public synchronized void addPlayer(Player player) {
        if (this.getPlayers().contains(player)) {
            return;
        }
        if (player.getScene() != null) {
            player.getScene().removePlayer(player);
        }
        this.getPlayers().add(player);
        player.setSceneId(this.getId());
        player.setScene(this);
        this.setupPlayerAvatars(player);
    }

    public synchronized void removePlayer(Player player) {
        if (this.getChallenge() != null && this.getChallenge().inProgress()) {
            player.sendPacket(new PacketDungeonChallengeFinishNotify(this.getChallenge()));
        }
        this.getPlayers().remove(player);
        player.setScene(null);
        this.removePlayerAvatars(player);
        for (EntityBaseGadget gadget : player.getTeamManager().getGadgets()) {
            this.removeEntity(gadget);
        }
        if (this.getPlayerCount() <= 0 && !this.dontDestroyWhenEmpty()) {
            this.getWorld().deregisterScene(this);
        }
    }

    private void setupPlayerAvatars(Player player) {
        player.getTeamManager().getActiveTeam().clear();
        TeamInfo teamInfo = player.getTeamManager().getCurrentTeamInfo();
        for (int avatarId : teamInfo.getAvatars()) {
            EntityAvatar entity = new EntityAvatar(player.getScene(), player.getAvatars().getAvatarById(avatarId));
            player.getTeamManager().getActiveTeam().add(entity);
        }
        if (player.getTeamManager().getCurrentCharacterIndex() >= player.getTeamManager().getActiveTeam().size() || player.getTeamManager().getCurrentCharacterIndex() < 0) {
            player.getTeamManager().setCurrentCharacterIndex(player.getTeamManager().getCurrentCharacterIndex() - 1);
        }
    }

    private void removePlayerAvatars(Player player) {
        Iterator<EntityAvatar> it = player.getTeamManager().getActiveTeam().iterator();
        while (it.hasNext()) {
            this.removeEntity(it.next(), VisionTypeOuterClass.VisionType.VISION_REMOVE);
            it.remove();
        }
    }

    public void spawnPlayer(Player player) {
        if (this.isInScene(player.getTeamManager().getCurrentAvatarEntity())) {
            return;
        }
        if (player.getTeamManager().getCurrentAvatarEntity().getFightProperty(FightProperty.FIGHT_PROP_CUR_HP) <= 0.0f) {
            player.getTeamManager().getCurrentAvatarEntity().setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, 1.0f);
        }
        this.addEntity(player.getTeamManager().getCurrentAvatarEntity());
        for (EntityAvatar entity : player.getTeamManager().getActiveTeam()) {
            if (entity.getAvatar().getSkillExtraChargeMap().size() <= 0) continue;
            player.sendPacket(new PacketAvatarSkillInfoNotify(entity.getAvatar()));
        }
    }

    private void addEntityDirectly(GameEntity entity) {
        this.getEntities().put(entity.getId(), entity);
    }

    public synchronized void addEntity(GameEntity entity) {
        this.addEntityDirectly(entity);
        this.broadcastPacket(new PacketSceneEntityAppearNotify(entity));
    }

    public synchronized void addEntityToSingleClient(Player player, GameEntity entity) {
        this.addEntityDirectly(entity);
        player.sendPacket(new PacketSceneEntityAppearNotify(entity));
    }

    public synchronized void addEntities(Collection<GameEntity> entities) {
        for (GameEntity entity : entities) {
            this.addEntityDirectly(entity);
        }
        this.broadcastPacket(new PacketSceneEntityAppearNotify(entities, VisionTypeOuterClass.VisionType.VISION_BORN));
    }

    private GameEntity removeEntityDirectly(GameEntity entity) {
        return (GameEntity)this.getEntities().remove(entity.getId());
    }

    public void removeEntity(GameEntity entity) {
        this.removeEntity(entity, VisionTypeOuterClass.VisionType.VISION_DIE);
    }

    public synchronized void removeEntity(GameEntity entity, VisionTypeOuterClass.VisionType visionType) {
        GameEntity removed = this.removeEntityDirectly(entity);
        if (removed != null) {
            this.broadcastPacket(new PacketSceneEntityDisappearNotify(removed, visionType));
        }
    }

    public synchronized void replaceEntity(EntityAvatar oldEntity, EntityAvatar newEntity) {
        this.removeEntityDirectly(oldEntity);
        this.addEntityDirectly(newEntity);
        this.broadcastPacket(new PacketSceneEntityDisappearNotify(oldEntity, VisionTypeOuterClass.VisionType.VISION_REPLACE));
        this.broadcastPacket(new PacketSceneEntityAppearNotify(newEntity, VisionTypeOuterClass.VisionType.VISION_REPLACE, oldEntity.getId()));
    }

    public void showOtherEntities(Player player) {
        LinkedList<GameEntity> entities = new LinkedList<GameEntity>();
        EntityAvatar currentEntity = player.getTeamManager().getCurrentAvatarEntity();
        for (GameEntity entity : this.getEntities().values()) {
            if (entity == currentEntity) continue;
            entities.add(entity);
        }
        player.sendPacket(new PacketSceneEntityAppearNotify(entities, VisionTypeOuterClass.VisionType.VISION_MEET));
    }

    public void handleAttack(AttackResultOuterClass.AttackResult result) {
        GameEntity target = this.getEntityById(result.getDefenseId());
        if (target == null) {
            return;
        }
        if (target instanceof EntityAvatar && ((EntityAvatar)target).getPlayer().inGodmode()) {
            return;
        }
        target.damage(result.getDamage(), result.getAttackerId());
    }

    public void killEntity(GameEntity target, int attackerId) {
        this.broadcastPacket(new PacketLifeStateChangeNotify(attackerId, target, LifeState.LIFE_DEAD));
        if (target instanceof EntityMonster && this.getSceneType() != SceneType.SCENE_DUNGEON) {
            this.getWorld().getServer().getDropManager().callDrop((EntityMonster)target);
        }
        this.removeEntity(target);
        target.onDeath(attackerId);
    }

    public void onTick() {
        if (this.getScriptManager().isInit()) {
            this.checkBlocks();
        } else {
            this.checkSpawns();
        }
        this.getScriptManager().onTick();
    }

    public void checkSpawns() {
        SpatialIndex<SpawnDataEntry.SpawnGroupEntry> list = GameDepot.getSpawnListById(this.getId());
        HashSet<SpawnDataEntry> visible = new HashSet<SpawnDataEntry>();
        for (Player player : this.getPlayers()) {
            int RANGE = 100;
            List<SpawnDataEntry.SpawnGroupEntry> entries = list.query({player.getPos().getX() - (float)RANGE, player.getPos().getZ() - (float)RANGE}, {player.getPos().getX() + (float)RANGE, player.getPos().getZ() + (float)RANGE});
            for (SpawnDataEntry.SpawnGroupEntry spawnGroupEntry : entries) {
                for (SpawnDataEntry spawnData : spawnGroupEntry.getSpawns()) {
                    visible.add(spawnData);
                }
            }
        }
        WorldLevelData worldLevelData = (WorldLevelData)GameData.getWorldLevelDataMap().get(this.getWorld().getWorldLevel());
        int worldLevelOverride = 0;
        if (worldLevelData != null) {
            worldLevelOverride = worldLevelData.getMonsterLevel();
        }
        LinkedList<GameEntity> toAdd = new LinkedList<GameEntity>();
        LinkedList<GameEntity> toRemove = new LinkedList<GameEntity>();
        for (SpawnDataEntry spawnDataEntry : visible) {
            MonsterData data;
            if (this.getSpawnedEntities().contains(spawnDataEntry) || this.getDeadSpawnedEntities().contains(spawnDataEntry) || (data = (MonsterData)GameData.getMonsterDataMap().get(spawnDataEntry.getMonsterId())) == null) continue;
            EntityMonster entity = new EntityMonster(this, data, spawnDataEntry.getPos(), worldLevelOverride > 0 ? worldLevelOverride : spawnDataEntry.getLevel());
            entity.getRotation().set(spawnDataEntry.getRot());
            entity.setGroupId(spawnDataEntry.getGroup().getGroupId());
            entity.setPoseId(spawnDataEntry.getPoseId());
            entity.setConfigId(spawnDataEntry.getConfigId());
            entity.setSpawnEntry(spawnDataEntry);
            toAdd.add(entity);
            this.getSpawnedEntities().add(spawnDataEntry);
        }
        for (GameEntity gameEntity : this.getEntities().values()) {
            if (gameEntity.getSpawnEntry() == null || visible.contains(gameEntity.getSpawnEntry())) continue;
            toRemove.add(gameEntity);
        }
        if (toAdd.size() > 0) {
            toAdd.stream().forEach(this::addEntityDirectly);
            this.broadcastPacket(new PacketSceneEntityAppearNotify(toAdd, VisionTypeOuterClass.VisionType.VISION_BORN));
        }
        if (toRemove.size() > 0) {
            toRemove.stream().forEach(this::removeEntityDirectly);
            this.broadcastPacket(new PacketSceneEntityDisappearNotify(toRemove, VisionTypeOuterClass.VisionType.VISION_REMOVE));
        }
    }

    public void checkBlocks() {
        HashSet<SceneBlock> visible = new HashSet<SceneBlock>();
        for (Player player : this.getPlayers()) {
            for (SceneBlock block : this.getScriptManager().getBlocks()) {
                if (!block.contains(player.getPos())) continue;
                visible.add(block);
            }
        }
        Iterator<SceneBlock> it = this.getLoadedBlocks().iterator();
        while (it.hasNext()) {
            SceneBlock block = it.next();
            if (visible.contains(block)) continue;
            it.remove();
            this.onUnloadBlock(block);
        }
        for (SceneBlock block : visible) {
            if (this.getLoadedBlocks().contains(block)) continue;
            this.onLoadBlock(block);
            this.getLoadedBlocks().add(block);
        }
    }

    public void onLoadBlock(SceneBlock block) {
        for (SceneGroup group : block.groups) {
            if (!group.isLoaded()) {
                this.getScriptManager().loadGroupFromScript(group);
            }
            group.triggers.forEach(this.getScriptManager()::registerTrigger);
            group.regions.forEach(this.getScriptManager()::registerRegion);
        }
        for (SceneGroup group : block.groups) {
            int suite;
            if (group.init_config == null || (suite = group.init_config.suite) == 0) continue;
            do {
                this.getScriptManager().spawnGadgetsInGroup(group, suite);
            } while (++suite < group.init_config.end_suite);
        }
    }

    public void onUnloadBlock(SceneBlock block) {
        List<GameEntity> toRemove = this.getEntities().values().stream().filter(e -> e.getBlockId() == block.id).toList();
        if (toRemove.size() > 0) {
            toRemove.stream().forEach(this::removeEntityDirectly);
            this.broadcastPacket(new PacketSceneEntityDisappearNotify(toRemove, VisionTypeOuterClass.VisionType.VISION_REMOVE));
        }
        for (SceneGroup group : block.groups) {
            group.triggers.forEach(this.getScriptManager()::deregisterTrigger);
            group.regions.forEach(this.getScriptManager()::deregisterRegion);
        }
    }

    public void onPlayerCreateGadget(EntityClientGadget gadget) {
        this.addEntityDirectly(gadget);
        gadget.getOwner().getTeamManager().getGadgets().add(gadget);
        if (this.getPlayerCount() == 1 && this.getPlayers().get(0) == gadget.getOwner()) {
            return;
        }
        this.broadcastPacketToOthers(gadget.getOwner(), new PacketSceneEntityAppearNotify(gadget));
    }

    public void onPlayerDestroyGadget(int entityId) {
        GameEntity entity = (GameEntity)this.getEntities().get(entityId);
        if (entity == null || !(entity instanceof EntityClientGadget)) {
            return;
        }
        EntityClientGadget gadget = (EntityClientGadget)entity;
        this.removeEntityDirectly(gadget);
        gadget.getOwner().getTeamManager().getGadgets().remove(gadget);
        if (this.getPlayerCount() == 1 && this.getPlayers().get(0) == gadget.getOwner()) {
            return;
        }
        this.broadcastPacketToOthers(gadget.getOwner(), new PacketSceneEntityDisappearNotify(gadget, VisionTypeOuterClass.VisionType.VISION_DIE));
    }

    public void broadcastPacket(BasePacket packet) {
        for (Player player : this.getPlayers()) {
            player.getSession().send(packet);
        }
    }

    public void broadcastPacketToOthers(Player excludedPlayer, BasePacket packet) {
        if (this.getPlayerCount() == 1 && this.getPlayers().get(0) == excludedPlayer) {
            return;
        }
        for (Player player : this.getPlayers()) {
            if (player == excludedPlayer) continue;
            player.getSession().send(packet);
        }
    }
}

