/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.quest;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Transient;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.custom.MainQuestData;
import emu.grasscutter.data.def.QuestData;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.quest.GameMainQuest;
import emu.grasscutter.game.quest.enums.LogicType;
import emu.grasscutter.game.quest.enums.QuestState;
import emu.grasscutter.net.proto.QuestOuterClass;
import emu.grasscutter.server.packet.send.PacketQuestListUpdateNotify;
import emu.grasscutter.server.packet.send.PacketQuestProgressUpdateNotify;
import emu.grasscutter.utils.Utils;

@Entity
public class GameQuest {
    @Transient
    private GameMainQuest mainQuest;
    @Transient
    private QuestData questData;
    private int questId;
    private int mainQuestId;
    private QuestState state;
    private int startTime;
    private int acceptTime;
    private int finishTime;
    private int[] finishProgressList;
    private int[] failProgressList;

    @Deprecated
    public GameQuest() {
    }

    public GameQuest(GameMainQuest mainQuest, QuestData questData) {
        this.mainQuest = mainQuest;
        this.questId = questData.getId();
        this.mainQuestId = questData.getMainId();
        this.questData = questData;
        this.startTime = this.acceptTime = Utils.getCurrentSeconds();
        this.state = QuestState.QUEST_STATE_UNFINISHED;
        if (questData.getFinishCond() != null) {
            this.finishProgressList = new int[questData.getFinishCond().length];
        }
        if (questData.getFailCond() != null) {
            this.failProgressList = new int[questData.getFailCond().length];
        }
        this.mainQuest.getChildQuests().put(this.questId, this);
    }

    public GameMainQuest getMainQuest() {
        return this.mainQuest;
    }

    public void setMainQuest(GameMainQuest mainQuest) {
        this.mainQuest = mainQuest;
    }

    public Player getOwner() {
        return this.getMainQuest().getOwner();
    }

    public int getQuestId() {
        return this.questId;
    }

    public int getMainQuestId() {
        return this.mainQuestId;
    }

    public QuestData getData() {
        return this.questData;
    }

    public void setConfig(QuestData config) {
        if (this.getQuestId() != config.getId()) {
            return;
        }
        this.questData = config;
    }

    public QuestState getState() {
        return this.state;
    }

    public void setState(QuestState state) {
        this.state = state;
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int startTime) {
        this.startTime = startTime;
    }

    public int getAcceptTime() {
        return this.acceptTime;
    }

    public void setAcceptTime(int acceptTime) {
        this.acceptTime = acceptTime;
    }

    public int getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(int finishTime) {
        this.finishTime = finishTime;
    }

    public int[] getFinishProgressList() {
        return this.finishProgressList;
    }

    public void setFinishProgress(int index, int value) {
        this.finishProgressList[index] = value;
    }

    public int[] getFailProgressList() {
        return this.failProgressList;
    }

    public void setFailProgress(int index, int value) {
        this.failProgressList[index] = value;
    }

    public void finish() {
        this.state = QuestState.QUEST_STATE_FINISHED;
        this.finishTime = Utils.getCurrentSeconds();
        if (this.getFinishProgressList() != null) {
            for (int i2 = 0; i2 < this.getFinishProgressList().length; ++i2) {
                this.getFinishProgressList()[i2] = 1;
            }
        }
        this.getOwner().getSession().send(new PacketQuestProgressUpdateNotify(this));
        this.getOwner().getSession().send(new PacketQuestListUpdateNotify(this));
        if (this.getData().finishParent()) {
            this.getMainQuest().finish();
        } else {
            this.tryAcceptQuestLine();
            this.save();
        }
    }

    public boolean tryAcceptQuestLine() {
        try {
            MainQuestData questConfig = (MainQuestData)GameData.getMainQuestDataMap().get(this.getMainQuestId());
            for (MainQuestData.SubQuestData subQuest : questConfig.getSubQuests()) {
                QuestData questData;
                GameQuest quest = this.getMainQuest().getChildQuestById(subQuest.getSubId());
                if (quest != null || (questData = (QuestData)GameData.getQuestDataMap().get(subQuest.getSubId())) == null || questData.getAcceptCond() == null) continue;
                int[] accept = new int[questData.getAcceptCond().length];
                for (int i2 = 0; i2 < questData.getAcceptCond().length; ++i2) {
                    QuestData.QuestCondition condition = questData.getAcceptCond()[i2];
                    boolean result = this.getOwner().getServer().getQuestHandler().triggerCondition(this, condition, condition.getParam());
                    accept[i2] = result ? 1 : 0;
                }
                boolean shouldAccept = LogicType.calculate(questData.getAcceptCondComb(), accept);
                if (!shouldAccept) continue;
                this.getOwner().getQuestManager().addQuest(questData.getId());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void save() {
        this.getMainQuest().save();
    }

    public QuestOuterClass.Quest toProto() {
        QuestOuterClass.Quest.Builder proto = QuestOuterClass.Quest.newBuilder().setQuestId(this.getQuestId()).setState(this.getState().getValue()).setParentQuestId(this.getMainQuestId()).setStartTime(this.getStartTime()).setStartGameTime(438).setAcceptTime(this.getAcceptTime());
        if (this.getFinishProgressList() != null) {
            for (int i2 : this.getFinishProgressList()) {
                proto.addFinishProgressList(i2);
            }
        }
        if (this.getFailProgressList() != null) {
            for (int i2 : this.getFailProgressList()) {
                proto.addFailProgressList(i2);
            }
        }
        return proto.build();
    }
}

