/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.props;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public enum LifeState {
    LIFE_NONE(0),
    LIFE_ALIVE(1),
    LIFE_DEAD(2),
    LIFE_REVIVE(3);

    private final int value;
    private static final Int2ObjectMap<LifeState> map;
    private static final Map<String, LifeState> stringMap;

    private LifeState(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static LifeState getTypeByValue(int value) {
        return map.getOrDefault(value, LIFE_NONE);
    }

    public static LifeState getTypeByName(String name) {
        return stringMap.getOrDefault(name, LIFE_NONE);
    }

    static {
        map = new Int2ObjectOpenHashMap<LifeState>();
        stringMap = new HashMap<String, LifeState>();
        Stream.of(LifeState.values()).forEach(e -> {
            map.put(e.getValue(), (LifeState)((Object)e));
            stringMap.put(e.name(), (LifeState)((Object)e));
        });
    }
}

