/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.player;

import dev.morphia.annotations.Entity;
import emu.grasscutter.Configuration;
import emu.grasscutter.game.avatar.Avatar;
import java.util.ArrayList;
import java.util.List;

@Entity
public class TeamInfo {
    private String name = "";
    private List<Integer> avatars;

    public TeamInfo() {
        this.avatars = new ArrayList<Integer>(Configuration.GAME_OPTIONS.avatarLimits.singlePlayerTeam);
    }

    public TeamInfo(List<Integer> avatars) {
        this.avatars = avatars;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Integer> getAvatars() {
        return this.avatars;
    }

    public int size() {
        return this.avatars.size();
    }

    public boolean contains(Avatar avatar) {
        return this.getAvatars().contains(avatar.getAvatarId());
    }

    public boolean addAvatar(Avatar avatar) {
        if (this.size() >= Configuration.GAME_OPTIONS.avatarLimits.singlePlayerTeam || this.contains(avatar)) {
            return false;
        }
        this.getAvatars().add(avatar.getAvatarId());
        return true;
    }

    public boolean removeAvatar(int slot) {
        if (this.size() <= 1) {
            return false;
        }
        this.getAvatars().remove(slot);
        return true;
    }

    public void copyFrom(TeamInfo team) {
        this.copyFrom(team, Configuration.GAME_OPTIONS.avatarLimits.singlePlayerTeam);
    }

    public void copyFrom(TeamInfo team, int maxTeamSize) {
        ArrayList<Integer> avatarIds = new ArrayList<Integer>(team.getAvatars());
        this.getAvatars().clear();
        int len2 = Math.min(avatarIds.size(), maxTeamSize);
        for (int i2 = 0; i2 < len2; ++i2) {
            int id = (Integer)avatarIds.get(i2);
            this.getAvatars().add(id);
        }
    }
}

