/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.managers.StaminaManager;

import ch.qos.logback.classic.Logger;
import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.data.GameData;
import emu.grasscutter.game.entity.EntityAvatar;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.managers.StaminaManager.AfterUpdateStaminaListener;
import emu.grasscutter.game.managers.StaminaManager.BeforeUpdateStaminaListener;
import emu.grasscutter.game.managers.StaminaManager.Consumption;
import emu.grasscutter.game.managers.StaminaManager.ConsumptionType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.game.props.LifeState;
import emu.grasscutter.game.props.PlayerProperty;
import emu.grasscutter.net.proto.EntityMoveInfoOuterClass;
import emu.grasscutter.net.proto.MotionInfoOuterClass;
import emu.grasscutter.net.proto.MotionStateOuterClass;
import emu.grasscutter.net.proto.PlayerDieTypeOuterClass;
import emu.grasscutter.net.proto.VectorOuterClass;
import emu.grasscutter.net.proto.VehicleInteractTypeOuterClass;
import emu.grasscutter.server.game.GameSession;
import emu.grasscutter.server.packet.send.PacketAvatarLifeStateChangeNotify;
import emu.grasscutter.server.packet.send.PacketEntityFightPropUpdateNotify;
import emu.grasscutter.server.packet.send.PacketLifeStateChangeNotify;
import emu.grasscutter.server.packet.send.PacketPlayerPropNotify;
import emu.grasscutter.server.packet.send.PacketVehicleStaminaNotify;
import emu.grasscutter.utils.Position;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.jetbrains.annotations.NotNull;

public class StaminaManager {
    private final Player player;
    private static final HashMap<String, HashSet<MotionStateOuterClass.MotionState>> MotionStatesCategorized = new HashMap<String, HashSet<MotionStateOuterClass.MotionState>>(){
        {
            this.put("CLIMB", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_CLIMB, MotionStateOuterClass.MotionState.MOTION_STANDBY_TO_CLIMB)));
            this.put("DASH", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_DANGER_DASH, MotionStateOuterClass.MotionState.MOTION_DASH)));
            this.put("FLY", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_FLY, MotionStateOuterClass.MotionState.MOTION_FLY_FAST, MotionStateOuterClass.MotionState.MOTION_FLY_SLOW, MotionStateOuterClass.MotionState.MOTION_POWERED_FLY)));
            this.put("RUN", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_DANGER_RUN, MotionStateOuterClass.MotionState.MOTION_RUN)));
            this.put("SKIFF", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_SKIFF_BOARDING, MotionStateOuterClass.MotionState.MOTION_SKIFF_DASH, MotionStateOuterClass.MotionState.MOTION_SKIFF_NORMAL, MotionStateOuterClass.MotionState.MOTION_SKIFF_POWERED_DASH)));
            this.put("STANDBY", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_DANGER_STANDBY_MOVE, MotionStateOuterClass.MotionState.MOTION_DANGER_STANDBY, MotionStateOuterClass.MotionState.MOTION_LADDER_TO_STANDBY, MotionStateOuterClass.MotionState.MOTION_STANDBY_MOVE, MotionStateOuterClass.MotionState.MOTION_STANDBY)));
            this.put("SWIM", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_SWIM_IDLE, MotionStateOuterClass.MotionState.MOTION_SWIM_DASH, MotionStateOuterClass.MotionState.MOTION_SWIM_JUMP, MotionStateOuterClass.MotionState.MOTION_SWIM_MOVE)));
            this.put("WALK", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_DANGER_WALK, MotionStateOuterClass.MotionState.MOTION_WALK)));
            this.put("OTHER", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_CLIMB_JUMP, MotionStateOuterClass.MotionState.MOTION_DASH_BEFORE_SHAKE, MotionStateOuterClass.MotionState.MOTION_FIGHT, MotionStateOuterClass.MotionState.MOTION_JUMP_UP_WALL_FOR_STANDBY, MotionStateOuterClass.MotionState.MOTION_NOTIFY, MotionStateOuterClass.MotionState.MOTION_SIT_IDLE, MotionStateOuterClass.MotionState.MOTION_JUMP)));
            this.put("NOCOST_NORECOVER", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_LADDER_SLIP, MotionStateOuterClass.MotionState.MOTION_SLIP, MotionStateOuterClass.MotionState.MOTION_FLY_IDLE)));
            this.put("IGNORE", new HashSet<MotionStateOuterClass.MotionState>(List.of(MotionStateOuterClass.MotionState.MOTION_CROUCH_IDLE, MotionStateOuterClass.MotionState.MOTION_CROUCH_MOVE, MotionStateOuterClass.MotionState.MOTION_CROUCH_ROLL, MotionStateOuterClass.MotionState.MOTION_DESTROY_VEHICLE, MotionStateOuterClass.MotionState.MOTION_FALL_ON_GROUND, MotionStateOuterClass.MotionState.MOTION_FOLLOW_ROUTE, MotionStateOuterClass.MotionState.MOTION_FORCE_SET_POS, MotionStateOuterClass.MotionState.MOTION_GO_UPSTAIRS, MotionStateOuterClass.MotionState.MOTION_JUMP_OFF_WALL, MotionStateOuterClass.MotionState.MOTION_LADDER_IDLE, MotionStateOuterClass.MotionState.MOTION_LADDER_MOVE, MotionStateOuterClass.MotionState.MOTION_LAND_SPEED, MotionStateOuterClass.MotionState.MOTION_MOVE_FAIL_ACK, MotionStateOuterClass.MotionState.MOTION_NONE, MotionStateOuterClass.MotionState.MOTION_NUM, MotionStateOuterClass.MotionState.MOTION_QUEST_FORCE_DRAG, MotionStateOuterClass.MotionState.MOTION_RESET, MotionStateOuterClass.MotionState.MOTION_STANDBY_TO_LADDER, MotionStateOuterClass.MotionState.MOTION_WATERFALL)));
        }
    };
    private final Logger logger = Grasscutter.getLogger();
    public static final int GlobalCharacterMaximumStamina = 24000;
    public static final int GlobalVehicleMaxStamina = 24000;
    private Position currentCoordinates = new Position(0.0f, 0.0f, 0.0f);
    private Position previousCoordinates = new Position(0.0f, 0.0f, 0.0f);
    private MotionStateOuterClass.MotionState currentState = MotionStateOuterClass.MotionState.MOTION_STANDBY;
    private MotionStateOuterClass.MotionState previousState = MotionStateOuterClass.MotionState.MOTION_STANDBY;
    private Timer sustainedStaminaHandlerTimer;
    private GameSession cachedSession = null;
    private GameEntity cachedEntity = null;
    private int staminaRecoverDelay = 0;
    private final HashMap<String, BeforeUpdateStaminaListener> beforeUpdateStaminaListeners = new HashMap();
    private final HashMap<String, AfterUpdateStaminaListener> afterUpdateStaminaListeners = new HashMap();
    private int lastSkillId = 0;
    private int lastSkillCasterId = 0;
    private boolean lastSkillFirstTick = true;
    private int vehicleId = -1;
    private int vehicleStamina = 24000;
    private static final HashSet<Integer> TalentMovements = new HashSet<Integer>(List.of(Integer.valueOf(10013), Integer.valueOf(10413)));
    private static final HashMap<Integer, Float> ClimbFoodReductionMap = new HashMap<Integer, Float>(){
        {
            this.put(0, Float.valueOf(0.8f));
        }
    };
    private static final HashMap<Integer, Float> DashFoodReductionMap = new HashMap<Integer, Float>(){
        {
            this.put(0, Float.valueOf(0.8f));
        }
    };
    private static final HashMap<Integer, Float> FlyFoodReductionMap = new HashMap<Integer, Float>(){
        {
            this.put(0, Float.valueOf(0.8f));
        }
    };
    private static final HashMap<Integer, Float> SwimFoodReductionMap = new HashMap<Integer, Float>(){
        {
            this.put(0, Float.valueOf(0.8f));
        }
    };
    private static final HashMap<Integer, Float> ClimbTalentReductionMap = new HashMap<Integer, Float>(){
        {
            this.put(262301, Float.valueOf(0.8f));
        }
    };
    private static final HashMap<Integer, Float> FlyTalentReductionMap = new HashMap<Integer, Float>(){
        {
            this.put(212301, Float.valueOf(0.8f));
            this.put(222301, Float.valueOf(0.8f));
        }
    };
    private static final HashMap<Integer, Float> SwimTalentReductionMap = new HashMap<Integer, Float>(){
        {
            this.put(242301, Float.valueOf(0.8f));
            this.put(542301, Float.valueOf(0.8f));
        }
    };
    public static final HashSet<Integer> BowAvatars = new HashSet();
    public static final HashSet<Integer> CatalystAvatars = new HashSet();
    public static final HashSet<Integer> ClaymoreAvatars = new HashSet();
    public static final HashSet<Integer> PolearmAvatars = new HashSet();
    public static final HashSet<Integer> SwordAvatars = new HashSet();

    public static void initialize() {
        GameData.getAvatarDataMap().forEach((avatarId, avatarData) -> {
            switch (avatarData.getWeaponType()) {
                case "WEAPON_BOW": {
                    BowAvatars.add((Integer)avatarId);
                    break;
                }
                case "WEAPON_CLAYMORE": {
                    ClaymoreAvatars.add((Integer)avatarId);
                    break;
                }
                case "WEAPON_CATALYST": {
                    CatalystAvatars.add((Integer)avatarId);
                    break;
                }
                case "WEAPON_POLE": {
                    PolearmAvatars.add((Integer)avatarId);
                    break;
                }
                case "WEAPON_SWORD_ONE_HAND": {
                    SwordAvatars.add((Integer)avatarId);
                }
            }
        });
    }

    public StaminaManager(Player player) {
        this.player = player;
    }

    public void setSkillCast(int skillId, int skillCasterId) {
        this.lastSkillFirstTick = true;
        this.lastSkillId = skillId;
        this.lastSkillCasterId = skillCasterId;
    }

    public int getMaxCharacterStamina() {
        return this.player.getProperty(PlayerProperty.PROP_MAX_STAMINA);
    }

    public int getCurrentCharacterStamina() {
        return this.player.getProperty(PlayerProperty.PROP_CUR_PERSIST_STAMINA);
    }

    public int getMaxVehicleStamina() {
        return 24000;
    }

    public int getCurrentVehicleStamina() {
        return this.vehicleStamina;
    }

    public boolean registerBeforeUpdateStaminaListener(String listenerName, BeforeUpdateStaminaListener listener) {
        if (this.beforeUpdateStaminaListeners.containsKey(listenerName)) {
            return false;
        }
        this.beforeUpdateStaminaListeners.put(listenerName, listener);
        return true;
    }

    public boolean unregisterBeforeUpdateStaminaListener(String listenerName) {
        if (!this.beforeUpdateStaminaListeners.containsKey(listenerName)) {
            return false;
        }
        this.beforeUpdateStaminaListeners.remove(listenerName);
        return true;
    }

    public boolean registerAfterUpdateStaminaListener(String listenerName, AfterUpdateStaminaListener listener) {
        if (this.afterUpdateStaminaListeners.containsKey(listenerName)) {
            return false;
        }
        this.afterUpdateStaminaListeners.put(listenerName, listener);
        return true;
    }

    public boolean unregisterAfterUpdateStaminaListener(String listenerName) {
        if (!this.afterUpdateStaminaListeners.containsKey(listenerName)) {
            return false;
        }
        this.afterUpdateStaminaListeners.remove(listenerName);
        return true;
    }

    private boolean isPlayerMoving() {
        float diffX = this.currentCoordinates.getX() - this.previousCoordinates.getX();
        float diffY = this.currentCoordinates.getY() - this.previousCoordinates.getY();
        float diffZ = this.currentCoordinates.getZ() - this.previousCoordinates.getZ();
        this.logger.trace("isPlayerMoving: " + this.previousCoordinates + ", " + this.currentCoordinates + ", " + diffX + ", " + diffY + ", " + diffZ);
        return (double)Math.abs(diffX) > 0.3 || (double)Math.abs(diffY) > 0.2 || (double)Math.abs(diffZ) > 0.3;
    }

    public int updateStaminaRelative(GameSession session, Consumption consumption, boolean isCharacterStamina) {
        int currentStamina;
        int n = currentStamina = isCharacterStamina ? this.getCurrentCharacterStamina() : this.getCurrentVehicleStamina();
        if (consumption.amount == 0) {
            return currentStamina;
        }
        for (Map.Entry<String, BeforeUpdateStaminaListener> listener : this.beforeUpdateStaminaListeners.entrySet()) {
            Consumption overriddenConsumption = listener.getValue().onBeforeUpdateStamina(consumption.type.toString(), consumption, isCharacterStamina);
            if (overriddenConsumption.type == consumption.type || overriddenConsumption.amount == consumption.amount) continue;
            this.logger.debug("Stamina update relative(" + consumption.type.toString() + ", " + consumption.amount + ") overridden to relative(" + consumption.type.toString() + ", " + consumption.amount + ") by: " + listener.getKey());
            return currentStamina;
        }
        int maxStamina = isCharacterStamina ? this.getMaxCharacterStamina() : this.getMaxVehicleStamina();
        this.logger.trace((isCharacterStamina ? "C " : "V ") + currentStamina + "/" + maxStamina + "\t" + this.currentState + "\t" + (this.isPlayerMoving() ? "moving" : "      ") + "\t(" + consumption.type + "," + consumption.amount + ")");
        int newStamina = currentStamina + consumption.amount;
        if (newStamina < 0) {
            newStamina = 0;
        } else if (newStamina > maxStamina) {
            newStamina = maxStamina;
        }
        return this.setStamina(session, consumption.type.toString(), newStamina, isCharacterStamina);
    }

    public int updateStaminaAbsolute(GameSession session, String reason, int newStamina, boolean isCharacterStamina) {
        int maxStamina;
        int currentStamina = isCharacterStamina ? this.getCurrentCharacterStamina() : this.getCurrentVehicleStamina();
        for (Map.Entry<String, BeforeUpdateStaminaListener> listener : this.beforeUpdateStaminaListeners.entrySet()) {
            int overriddenNewStamina = listener.getValue().onBeforeUpdateStamina(reason, newStamina, isCharacterStamina);
            if (overriddenNewStamina == newStamina) continue;
            this.logger.debug("Stamina update absolute(" + reason + ", " + newStamina + ") overridden to absolute(" + reason + ", " + newStamina + ") by: " + listener.getKey());
            return currentStamina;
        }
        int n = maxStamina = isCharacterStamina ? this.getMaxCharacterStamina() : this.getMaxVehicleStamina();
        if (newStamina < 0) {
            newStamina = 0;
        } else if (newStamina > maxStamina) {
            newStamina = maxStamina;
        }
        return this.setStamina(session, reason, newStamina, isCharacterStamina);
    }

    public int setStamina(GameSession session, String reason, int newStamina, boolean isCharacterStamina) {
        if (!Configuration.GAME_OPTIONS.staminaUsage || session.getPlayer().getStamina()) {
            newStamina = this.getMaxCharacterStamina();
        }
        if (isCharacterStamina) {
            this.player.setProperty(PlayerProperty.PROP_CUR_PERSIST_STAMINA, newStamina);
            session.send(new PacketPlayerPropNotify(this.player, PlayerProperty.PROP_CUR_PERSIST_STAMINA));
        } else {
            this.vehicleStamina = newStamina;
            session.send(new PacketVehicleStaminaNotify(this.vehicleId, (float)newStamina / 100.0f));
        }
        for (Map.Entry<String, AfterUpdateStaminaListener> listener : this.afterUpdateStaminaListeners.entrySet()) {
            listener.getValue().onAfterUpdateStamina(reason, newStamina, isCharacterStamina);
        }
        return newStamina;
    }

    public void killAvatar(GameSession session, GameEntity entity, PlayerDieTypeOuterClass.PlayerDieType dieType) {
        session.send(new PacketAvatarLifeStateChangeNotify(this.player.getTeamManager().getCurrentAvatarEntity().getAvatar(), LifeState.LIFE_DEAD, dieType));
        session.send(new PacketLifeStateChangeNotify(entity, LifeState.LIFE_DEAD, dieType));
        entity.setFightProperty(FightProperty.FIGHT_PROP_CUR_HP, 0.0f);
        entity.getWorld().broadcastPacket(new PacketEntityFightPropUpdateNotify(entity, FightProperty.FIGHT_PROP_CUR_HP));
        entity.getWorld().broadcastPacket(new PacketLifeStateChangeNotify(0, entity, LifeState.LIFE_DEAD));
        this.player.getScene().removeEntity(entity);
        ((EntityAvatar)entity).onDeath(dieType, 0);
    }

    public void startSustainedStaminaHandler() {
        if (!this.player.isPaused() && this.sustainedStaminaHandlerTimer == null) {
            this.sustainedStaminaHandlerTimer = new Timer();
            this.sustainedStaminaHandlerTimer.scheduleAtFixedRate((TimerTask)new SustainedStaminaHandler(), 0L, 200L);
            this.logger.debug("[MovementManager] SustainedStaminaHandlerTimer started");
        }
    }

    public void stopSustainedStaminaHandler() {
        if (this.sustainedStaminaHandlerTimer != null) {
            this.sustainedStaminaHandlerTimer.cancel();
            this.sustainedStaminaHandlerTimer = null;
            this.logger.debug("[MovementManager] SustainedStaminaHandlerTimer stopped");
        }
    }

    public void handleEvtDoSkillSuccNotify(GameSession session, int skillId, int casterId) {
        if (casterId != this.player.getTeamManager().getCurrentAvatarEntity().getId()) {
            return;
        }
        this.setSkillCast(skillId, casterId);
        int currentAvatarId = this.player.getTeamManager().getCurrentAvatarEntity().getAvatar().getAvatarId();
        if (ClaymoreAvatars.contains(currentAvatarId)) {
            return;
        }
        if (BowAvatars.contains(currentAvatarId) || SwordAvatars.contains(currentAvatarId) || PolearmAvatars.contains(currentAvatarId) || CatalystAvatars.contains(currentAvatarId)) {
            return;
        }
        this.handleImmediateStamina(session, skillId);
    }

    public void handleMixinCostStamina(boolean isSwim) {
        if (this.lastSkillCasterId == this.player.getTeamManager().getCurrentAvatarEntity().getId()) {
            this.handleImmediateStamina(this.cachedSession, this.lastSkillId);
        }
    }

    public void handleCombatInvocationsNotify(@NotNull GameSession session, @NotNull EntityMoveInfoOuterClass.EntityMoveInfo moveInfo, @NotNull GameEntity entity) {
        int currentAvatarEntityId;
        this.cachedSession = session;
        this.cachedEntity = entity;
        MotionInfoOuterClass.MotionInfo motionInfo = moveInfo.getMotionInfo();
        MotionStateOuterClass.MotionState motionState = motionInfo.getState();
        int notifyEntityId = entity.getId();
        if (notifyEntityId != (currentAvatarEntityId = session.getPlayer().getTeamManager().getCurrentAvatarEntity().getId()) && notifyEntityId != this.vehicleId) {
            return;
        }
        this.currentState = motionState;
        VectorOuterClass.Vector posVector = motionInfo.getPos();
        Position newPos = new Position(posVector.getX(), posVector.getY(), posVector.getZ());
        if (newPos.getX() != 0.0f && newPos.getY() != 0.0f && newPos.getZ() != 0.0f) {
            this.currentCoordinates = newPos;
        }
        this.startSustainedStaminaHandler();
        this.handleImmediateStamina(session, motionState);
    }

    public void handleVehicleInteractReq(GameSession session, int vehicleId, VehicleInteractTypeOuterClass.VehicleInteractType vehicleInteractType) {
        if (vehicleInteractType == VehicleInteractTypeOuterClass.VehicleInteractType.VEHICLE_INTERACT_IN) {
            this.vehicleId = vehicleId;
            this.updateStaminaAbsolute(session, "board vehicle", this.getMaxCharacterStamina(), true);
            this.updateStaminaAbsolute(session, "board vehicle", this.getMaxVehicleStamina(), false);
        } else {
            this.vehicleId = -1;
        }
    }

    private void handleImmediateStamina(GameSession session, @NotNull MotionStateOuterClass.MotionState motionState) {
        switch (motionState) {
            case MOTION_CLIMB: {
                if (this.currentState == MotionStateOuterClass.MotionState.MOTION_CLIMB) break;
                this.updateStaminaRelative(session, new Consumption(ConsumptionType.CLIMB_START), true);
                break;
            }
            case MOTION_DASH_BEFORE_SHAKE: {
                if (this.previousState == MotionStateOuterClass.MotionState.MOTION_DASH_BEFORE_SHAKE) break;
                this.updateStaminaRelative(session, new Consumption(ConsumptionType.SPRINT), true);
                break;
            }
            case MOTION_CLIMB_JUMP: {
                if (this.previousState == MotionStateOuterClass.MotionState.MOTION_CLIMB_JUMP) break;
                this.updateStaminaRelative(session, new Consumption(ConsumptionType.CLIMB_JUMP), true);
                break;
            }
            case MOTION_SWIM_DASH: {
                if (this.previousState == MotionStateOuterClass.MotionState.MOTION_SWIM_DASH) break;
                this.updateStaminaRelative(session, new Consumption(ConsumptionType.SWIM_DASH_START), true);
            }
        }
    }

    private void handleImmediateStamina(GameSession session, int skillId) {
        Consumption consumption = this.getFightConsumption(skillId);
        this.updateStaminaRelative(session, consumption, true);
    }

    private void handleDrowning() {
        int stamina = this.getCurrentCharacterStamina();
        if (stamina < 10) {
            this.logger.trace(this.getCurrentCharacterStamina() + "/" + this.getMaxCharacterStamina() + "\t" + this.currentState);
            if (this.currentState != MotionStateOuterClass.MotionState.MOTION_SWIM_IDLE) {
                this.killAvatar(this.cachedSession, this.cachedEntity, PlayerDieTypeOuterClass.PlayerDieType.PLAYER_DIE_DRAWN);
            }
        }
    }

    private Consumption getFightConsumption(int skillCasting) {
        if (TalentMovements.contains(skillCasting)) {
            return this.getTalentMovingSustainedCost(skillCasting);
        }
        int currentAvatarId = this.player.getTeamManager().getCurrentAvatarEntity().getAvatar().getAvatarId();
        if (BowAvatars.contains(currentAvatarId)) {
            return this.getBowSustainedCost(skillCasting);
        }
        if (ClaymoreAvatars.contains(currentAvatarId)) {
            return this.getClaymoreSustainedCost(skillCasting);
        }
        if (CatalystAvatars.contains(currentAvatarId)) {
            return this.getCatalystCost(skillCasting);
        }
        if (PolearmAvatars.contains(currentAvatarId)) {
            return this.getPolearmCost(skillCasting);
        }
        if (SwordAvatars.contains(skillCasting)) {
            return this.getSwordCost(skillCasting);
        }
        return new Consumption();
    }

    private Consumption getClimbConsumption() {
        Consumption consumption = new Consumption();
        if (this.currentState == MotionStateOuterClass.MotionState.MOTION_CLIMB && this.isPlayerMoving()) {
            consumption.type = ConsumptionType.CLIMBING;
            consumption.amount = ConsumptionType.CLIMBING.amount;
        }
        consumption.amount = (int)((float)consumption.amount * this.getFoodCostReductionFactor(ClimbFoodReductionMap));
        consumption.amount = (int)((float)consumption.amount * this.getTalentCostReductionFactor(ClimbTalentReductionMap));
        return consumption;
    }

    private Consumption getSwimConsumptions() {
        this.handleDrowning();
        Consumption consumption = new Consumption();
        if (this.currentState == MotionStateOuterClass.MotionState.MOTION_SWIM_MOVE) {
            consumption.type = ConsumptionType.SWIMMING;
            consumption.amount = ConsumptionType.SWIMMING.amount;
        }
        if (this.currentState == MotionStateOuterClass.MotionState.MOTION_SWIM_DASH) {
            consumption.type = ConsumptionType.SWIM_DASH;
            consumption.amount = ConsumptionType.SWIM_DASH.amount;
        }
        consumption.amount = (int)((float)consumption.amount * this.getFoodCostReductionFactor(SwimFoodReductionMap));
        consumption.amount = (int)((float)consumption.amount * this.getTalentCostReductionFactor(SwimTalentReductionMap));
        return consumption;
    }

    private Consumption getDashConsumption() {
        Consumption consumption = new Consumption();
        if (this.currentState == MotionStateOuterClass.MotionState.MOTION_DASH) {
            consumption.type = ConsumptionType.DASH;
            consumption.amount = ConsumptionType.DASH.amount;
            consumption.amount = (int)((float)consumption.amount * this.getFoodCostReductionFactor(DashFoodReductionMap));
        }
        return consumption;
    }

    private Consumption getFlyConsumption() {
        if (this.currentState == MotionStateOuterClass.MotionState.MOTION_POWERED_FLY) {
            return new Consumption(ConsumptionType.POWERED_FLY);
        }
        Consumption consumption = new Consumption(ConsumptionType.FLY);
        consumption.amount = (int)((float)consumption.amount * this.getFoodCostReductionFactor(FlyFoodReductionMap));
        consumption.amount = (int)((float)consumption.amount * this.getTalentCostReductionFactor(FlyTalentReductionMap));
        return consumption;
    }

    private Consumption getSkiffConsumption() {
        return switch (this.currentState) {
            case MotionStateOuterClass.MotionState.MOTION_SKIFF_DASH -> new Consumption(ConsumptionType.SKIFF_DASH);
            case MotionStateOuterClass.MotionState.MOTION_SKIFF_POWERED_DASH -> new Consumption(ConsumptionType.POWERED_SKIFF);
            case MotionStateOuterClass.MotionState.MOTION_SKIFF_NORMAL -> new Consumption(ConsumptionType.SKIFF);
            default -> new Consumption();
        };
    }

    private Consumption getOtherConsumptions() {
        switch (this.currentState) {
            case MOTION_NOTIFY: {
                break;
            }
            case MOTION_FIGHT: {
                return new Consumption(ConsumptionType.FIGHT, 500);
            }
        }
        return new Consumption();
    }

    private float getTalentCostReductionFactor(HashMap<Integer, Float> talentReductionMap) {
        float reduction = 1.0f;
        for (EntityAvatar entity : this.cachedSession.getPlayer().getTeamManager().getActiveTeam()) {
            for (int skillId : entity.getAvatar().getProudSkillList()) {
                float potentialLowerReduction;
                if (!talentReductionMap.containsKey(skillId) || !((potentialLowerReduction = talentReductionMap.get(skillId).floatValue()) < reduction)) continue;
                reduction = potentialLowerReduction;
            }
        }
        return reduction;
    }

    private float getFoodCostReductionFactor(HashMap<Integer, Float> foodReductionMap) {
        float reduction = 1.0f;
        return reduction;
    }

    private Consumption getTalentMovingSustainedCost(int skillId) {
        if (this.lastSkillFirstTick) {
            this.lastSkillFirstTick = false;
            return new Consumption(ConsumptionType.TALENT_DASH, -1000);
        }
        return new Consumption(ConsumptionType.TALENT_DASH, -500);
    }

    private Consumption getBowSustainedCost(int skillId) {
        return new Consumption(ConsumptionType.FIGHT, 500);
    }

    private Consumption getCatalystCost(int skillId) {
        Consumption consumption = new Consumption(ConsumptionType.FIGHT, -5000);
        return consumption;
    }

    private Consumption getClaymoreSustainedCost(int skillId) {
        Consumption consumption = new Consumption(ConsumptionType.FIGHT, -1333);
        switch (skillId) {
            case 10532: 
            case 10571: {
                consumption.amount = 0;
                break;
            }
            case 10160: {
                if (!this.player.getTeamManager().getCurrentAvatarEntity().getAvatar().getProudSkillList().contains(162101)) break;
                consumption.amount /= 2;
            }
        }
        return consumption;
    }

    private Consumption getPolearmCost(int skillId) {
        Consumption consumption = new Consumption(ConsumptionType.FIGHT, -2500);
        return consumption;
    }

    private Consumption getSwordCost(int skillId) {
        Consumption consumption = new Consumption(ConsumptionType.FIGHT, -2000);
        switch (skillId) {
            case 10421: {
                consumption.amount = -2500;
            }
        }
        return consumption;
    }

    private class SustainedStaminaHandler
    extends TimerTask {
        private SustainedStaminaHandler() {
        }

        @Override
        public void run() {
            boolean moving = StaminaManager.this.isPlayerMoving();
            int currentCharacterStamina = StaminaManager.this.getCurrentCharacterStamina();
            int maxCharacterStamina = StaminaManager.this.getMaxCharacterStamina();
            int currentVehicleStamina = StaminaManager.this.getCurrentVehicleStamina();
            int maxVehicleStamina = StaminaManager.this.getMaxVehicleStamina();
            if (moving || currentCharacterStamina < maxCharacterStamina || currentVehicleStamina < maxVehicleStamina) {
                Consumption consumption;
                StaminaManager.this.logger.trace("Player moving: " + moving + ", stamina full: " + (currentCharacterStamina >= maxCharacterStamina) + ", recalculate stamina");
                boolean isCharacterStamina = true;
                if (MotionStatesCategorized.get("CLIMB").contains(StaminaManager.this.currentState)) {
                    consumption = StaminaManager.this.getClimbConsumption();
                } else if (MotionStatesCategorized.get("DASH").contains(StaminaManager.this.currentState)) {
                    consumption = StaminaManager.this.getDashConsumption();
                } else if (MotionStatesCategorized.get("FLY").contains(StaminaManager.this.currentState)) {
                    consumption = StaminaManager.this.getFlyConsumption();
                } else if (MotionStatesCategorized.get("RUN").contains(StaminaManager.this.currentState)) {
                    consumption = new Consumption(ConsumptionType.RUN);
                } else if (MotionStatesCategorized.get("SKIFF").contains(StaminaManager.this.currentState)) {
                    consumption = StaminaManager.this.getSkiffConsumption();
                    isCharacterStamina = false;
                } else if (MotionStatesCategorized.get("STANDBY").contains(StaminaManager.this.currentState)) {
                    consumption = new Consumption(ConsumptionType.STANDBY);
                } else if (MotionStatesCategorized.get("SWIM").contains(StaminaManager.this.currentState)) {
                    consumption = StaminaManager.this.getSwimConsumptions();
                } else if (MotionStatesCategorized.get("WALK").contains(StaminaManager.this.currentState)) {
                    consumption = new Consumption(ConsumptionType.WALK);
                } else if (MotionStatesCategorized.get("NOCOST_NORECOVER").contains(StaminaManager.this.currentState)) {
                    consumption = new Consumption();
                } else if (MotionStatesCategorized.get("OTHER").contains(StaminaManager.this.currentState)) {
                    consumption = StaminaManager.this.getOtherConsumptions();
                } else {
                    return;
                }
                if (consumption.amount < 0 && isCharacterStamina && StaminaManager.this.player.getTeamManager().getTeamResonances().contains(10301)) {
                    consumption.amount = (int)((float)consumption.amount * 0.85f);
                }
                if (consumption.amount != 0 && StaminaManager.this.cachedSession != null) {
                    if (consumption.amount < 0) {
                        StaminaManager.this.staminaRecoverDelay = 0;
                    }
                    if (consumption.amount > 0 && consumption.type != ConsumptionType.POWERED_FLY && consumption.type != ConsumptionType.POWERED_SKIFF && StaminaManager.this.staminaRecoverDelay < 5) {
                        ++StaminaManager.this.staminaRecoverDelay;
                        consumption.amount = 0;
                        StaminaManager.this.logger.trace("Delaying recovery: " + StaminaManager.this.staminaRecoverDelay);
                    }
                    StaminaManager.this.updateStaminaRelative(StaminaManager.this.cachedSession, consumption, isCharacterStamina);
                }
            }
            StaminaManager.this.previousState = StaminaManager.this.currentState;
            StaminaManager.this.previousCoordinates = new Position(StaminaManager.this.currentCoordinates.getX(), StaminaManager.this.currentCoordinates.getY(), StaminaManager.this.currentCoordinates.getZ());
        }
    }
}

