/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.mail;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.mail.Mail;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.server.event.player.PlayerReceiveMailEvent;
import emu.grasscutter.server.packet.send.PacketDelMailRsp;
import emu.grasscutter.server.packet.send.PacketMailChangeNotify;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MailHandler {
    private final Player player;
    private final List<Mail> mail;

    public MailHandler(Player player) {
        this.player = player;
        this.mail = new ArrayList<Mail>();
    }

    public Player getPlayer() {
        return this.player;
    }

    public List<Mail> getMail() {
        return this.mail;
    }

    public void sendMail(Mail message) {
        PlayerReceiveMailEvent event = new PlayerReceiveMailEvent(this.getPlayer(), message);
        event.call();
        if (event.isCanceled()) {
            return;
        }
        message = event.getMessage();
        message.setOwnerUid(this.getPlayer().getUid());
        message.save();
        this.mail.add(message);
        Grasscutter.getLogger().debug("Mail sent to user [" + this.getPlayer().getUid() + ":" + this.getPlayer().getNickname() + "]!");
        if (this.getPlayer().isOnline()) {
            this.getPlayer().sendPacket(new PacketMailChangeNotify(this.getPlayer(), message));
        }
    }

    public boolean deleteMail(int mailId) {
        Mail message = this.getMailById(mailId);
        if (message != null) {
            this.getMail().remove(mailId);
            message.expireTime = 0L;
            message.save();
            return true;
        }
        return false;
    }

    public void deleteMail(List<Integer> mailList) {
        ArrayList<Integer> sortedMailList = new ArrayList<Integer>();
        sortedMailList.addAll(mailList);
        Collections.sort(sortedMailList, Collections.reverseOrder());
        ArrayList<Integer> deleted = new ArrayList<Integer>();
        Iterator iterator2 = sortedMailList.iterator();
        while (iterator2.hasNext()) {
            int id = (Integer)iterator2.next();
            if (!this.deleteMail(id)) continue;
            deleted.add(id);
        }
        this.player.getSession().send(new PacketDelMailRsp(this.player, deleted));
        this.player.getSession().send(new PacketMailChangeNotify(this.player, null, deleted));
    }

    public Mail getMailById(int index) {
        return this.mail.get(index);
    }

    public int getMailIndex(Mail message) {
        return this.mail.indexOf(message);
    }

    public boolean replaceMailByIndex(int index, Mail message) {
        if (this.getMailById(index) != null) {
            this.mail.set(index, message);
            message.save();
            return true;
        }
        return false;
    }

    public void loadFromDatabase() {
        List<Mail> mailList = DatabaseHelper.getAllMail(this.getPlayer());
        for (Mail mail : mailList) {
            this.getMail().add(mail);
        }
    }
}

