/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.inventory;

import emu.grasscutter.Configuration;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.common.ItemParamData;
import emu.grasscutter.data.def.AvatarCostumeData;
import emu.grasscutter.data.def.AvatarData;
import emu.grasscutter.data.def.AvatarFlycloakData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.avatar.AvatarStorage;
import emu.grasscutter.game.inventory.EquipInventoryTab;
import emu.grasscutter.game.inventory.EquipType;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.InventoryTab;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.inventory.MaterialInventoryTab;
import emu.grasscutter.game.inventory.MaterialType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.ActionReason;
import emu.grasscutter.net.proto.ItemParamOuterClass;
import emu.grasscutter.server.packet.send.PacketAvatarEquipChangeNotify;
import emu.grasscutter.server.packet.send.PacketItemAddHintNotify;
import emu.grasscutter.server.packet.send.PacketStoreItemChangeNotify;
import emu.grasscutter.server.packet.send.PacketStoreItemDelNotify;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Inventory
implements Iterable<GameItem> {
    private final Player player;
    private final Long2ObjectMap<GameItem> store;
    private final Int2ObjectMap<InventoryTab> inventoryTypes;

    public Inventory(Player player) {
        this.player = player;
        this.store = new Long2ObjectOpenHashMap<GameItem>();
        this.inventoryTypes = new Int2ObjectOpenHashMap<InventoryTab>();
        this.createInventoryTab(ItemType.ITEM_WEAPON, new EquipInventoryTab(Configuration.INVENTORY_LIMITS.weapons));
        this.createInventoryTab(ItemType.ITEM_RELIQUARY, new EquipInventoryTab(Configuration.INVENTORY_LIMITS.relics));
        this.createInventoryTab(ItemType.ITEM_MATERIAL, new MaterialInventoryTab(Configuration.INVENTORY_LIMITS.materials));
        this.createInventoryTab(ItemType.ITEM_FURNITURE, new MaterialInventoryTab(Configuration.INVENTORY_LIMITS.furniture));
    }

    public Player getPlayer() {
        return this.player;
    }

    public AvatarStorage getAvatarStorage() {
        return this.getPlayer().getAvatars();
    }

    public Long2ObjectMap<GameItem> getItems() {
        return this.store;
    }

    public Int2ObjectMap<InventoryTab> getInventoryTypes() {
        return this.inventoryTypes;
    }

    public InventoryTab getInventoryTab(ItemType type2) {
        return (InventoryTab)this.getInventoryTypes().get(type2.getValue());
    }

    public void createInventoryTab(ItemType type2, InventoryTab tab) {
        this.getInventoryTypes().put(type2.getValue(), tab);
    }

    public GameItem getItemByGuid(long id) {
        return (GameItem)this.getItems().get(id);
    }

    public boolean addItem(int itemId) {
        return this.addItem(itemId, 1);
    }

    public boolean addItem(int itemId, int count) {
        ItemData itemData = (ItemData)GameData.getItemDataMap().get(itemId);
        if (itemData == null) {
            return false;
        }
        GameItem item = new GameItem(itemData, count);
        return this.addItem(item);
    }

    public boolean addItem(GameItem item) {
        GameItem result = this.putItem(item);
        if (result != null) {
            this.getPlayer().sendPacket(new PacketStoreItemChangeNotify(result));
            return true;
        }
        return false;
    }

    public boolean addItem(GameItem item, ActionReason reason) {
        boolean result = this.addItem(item);
        if (result && reason != null) {
            this.getPlayer().sendPacket(new PacketItemAddHintNotify(item, reason));
        }
        return result;
    }

    public boolean addItem(GameItem item, ActionReason reason, boolean forceNotify) {
        boolean result = this.addItem(item);
        if (reason != null && (forceNotify || result)) {
            this.getPlayer().sendPacket(new PacketItemAddHintNotify(item, reason));
        }
        return result;
    }

    public void addItems(Collection<GameItem> items) {
        this.addItems(items, null);
    }

    public void addItems(Collection<GameItem> items, ActionReason reason) {
        LinkedList<GameItem> changedItems = new LinkedList<GameItem>();
        for (GameItem item : items) {
            GameItem result = this.putItem(item);
            if (result == null) continue;
            changedItems.add(result);
        }
        if (changedItems.size() == 0) {
            return;
        }
        if (reason != null) {
            this.getPlayer().sendPacket(new PacketItemAddHintNotify(changedItems, reason));
        }
        this.getPlayer().sendPacket(new PacketStoreItemChangeNotify(changedItems));
    }

    public void addItemParams(Collection<ItemParamOuterClass.ItemParam> items) {
        this.addItems(items.stream().map(param -> new GameItem(param.getItemId(), param.getCount())).toList(), null);
    }

    public void addItemParamDatas(Collection<ItemParamData> items) {
        this.addItemParamDatas(items, null);
    }

    public void addItemParamDatas(Collection<ItemParamData> items, ActionReason reason) {
        this.addItems(items.stream().map(param -> new GameItem(param.getItemId(), param.getCount())).toList(), reason);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized GameItem putItem(GameItem item) {
        if (item.getItemData() == null) {
            return null;
        }
        ItemType type2 = item.getItemData().getItemType();
        InventoryTab tab = this.getInventoryTab(type2);
        if (type2 == ItemType.ITEM_WEAPON || type2 == ItemType.ITEM_RELIQUARY) {
            if (tab.getSize() >= tab.getMaxCapacity()) {
                return null;
            }
            item.setCount(Math.max(item.getCount(), 1));
            this.putItem(item, tab);
        } else {
            if (type2 == ItemType.ITEM_VIRTUAL) {
                this.addVirtualItem(item.getItemId(), item.getCount());
                return item;
            }
            if (item.getItemData().getMaterialType() == MaterialType.MATERIAL_ADSORBATE) {
                this.player.getTeamManager().addEnergyToTeam(item);
                return null;
            }
            if (item.getItemData().getMaterialType() == MaterialType.MATERIAL_AVATAR) {
                int avatarId = item.getItemId() % 1000 + 10000000;
                if (avatarId == 10000005 || avatarId == 10000007) {
                    return null;
                }
                AvatarData avatarData = (AvatarData)GameData.getAvatarDataMap().get(avatarId);
                if (avatarData == null || this.player.getAvatars().hasAvatar(avatarId)) return null;
                this.getPlayer().addAvatar(new Avatar(avatarData));
                return null;
            }
            if (item.getItemData().getMaterialType() == MaterialType.MATERIAL_FLYCLOAK) {
                AvatarFlycloakData flycloakData = (AvatarFlycloakData)GameData.getAvatarFlycloakDataMap().get(item.getItemId());
                if (flycloakData == null || this.player.getFlyCloakList().contains(item.getItemId())) return null;
                this.getPlayer().addFlycloak(item.getItemId());
                return null;
            }
            if (item.getItemData().getMaterialType() == MaterialType.MATERIAL_COSTUME) {
                AvatarCostumeData costumeData = (AvatarCostumeData)GameData.getAvatarCostumeDataItemIdMap().get(item.getItemId());
                if (costumeData == null || this.player.getCostumeList().contains(costumeData.getId())) return null;
                this.getPlayer().addCostume(costumeData.getId());
                return null;
            }
            if (item.getItemData().getMaterialType() == MaterialType.MATERIAL_NAMECARD) {
                if (this.player.getNameCardList().contains(item.getItemId())) return null;
                this.getPlayer().addNameCard(item.getItemId());
                return null;
            }
            if (tab == null) return null;
            GameItem existingItem = tab.getItemById(item.getItemId());
            if (existingItem == null) {
                if (tab.getSize() >= tab.getMaxCapacity()) {
                    return null;
                }
                this.putItem(item, tab);
            } else {
                existingItem.setCount(Math.min(existingItem.getCount() + item.getCount(), item.getItemData().getStackLimit()));
                existingItem.save();
                return existingItem;
            }
        }
        if (item.getItemData().getItemType() == ItemType.ITEM_VIRTUAL) return item;
        item.save();
        return item;
    }

    private synchronized void putItem(GameItem item, InventoryTab tab) {
        item.setOwner(this.getPlayer());
        this.getItems().put(item.getGuid(), item);
        if (tab != null) {
            tab.onAddItem(item);
        }
    }

    private void addVirtualItem(int itemId, int count) {
        switch (itemId) {
            case 101: {
                this.getPlayer().getServer().getInventoryManager().upgradeAvatar(this.player, this.getPlayer().getTeamManager().getCurrentAvatarEntity().getAvatar(), count);
                break;
            }
            case 102: {
                this.getPlayer().addExpDirectly(count);
                break;
            }
            case 105: {
                this.getPlayer().getServer().getInventoryManager().upgradeAvatarFetterLevel(this.player, this.getPlayer().getTeamManager().getCurrentAvatarEntity().getAvatar(), count);
                break;
            }
            case 201: {
                this.getPlayer().setPrimogems(this.player.getPrimogems() + count);
                break;
            }
            case 202: {
                this.getPlayer().setMora(this.player.getMora() + count);
                break;
            }
            case 203: {
                this.getPlayer().setCrystals(this.player.getCrystals() + count);
            }
        }
    }

    private int getVirtualItemCount(int itemId) {
        switch (itemId) {
            case 201: {
                return this.player.getPrimogems();
            }
            case 202: {
                return this.player.getMora();
            }
            case 203: {
                return this.player.getCrystals();
            }
        }
        GameItem item = this.getInventoryTab(ItemType.ITEM_MATERIAL).getItemById(itemId);
        return item == null ? 0 : item.getCount();
    }

    public boolean payItem(int id, int count) {
        return this.payItem(new ItemParamData(id, count));
    }

    public boolean payItem(ItemParamData costItem) {
        return this.payItems(new ItemParamData[]{costItem}, 1, null);
    }

    public boolean payItems(ItemParamData[] costItems) {
        return this.payItems(costItems, 1, null);
    }

    public boolean payItems(ItemParamData[] costItems, int quantity) {
        return this.payItems(costItems, quantity, null);
    }

    public synchronized boolean payItems(ItemParamData[] costItems, int quantity, ActionReason reason) {
        for (ItemParamData cost : costItems) {
            if (this.getVirtualItemCount(cost.getId()) >= cost.getCount() * quantity) continue;
            return false;
        }
        block6: for (ItemParamData cost : costItems) {
            switch (cost.getId()) {
                case 201: {
                    this.player.setPrimogems(this.player.getPrimogems() - cost.getCount() * quantity);
                    continue block6;
                }
                case 202: {
                    this.player.setMora(this.player.getMora() - cost.getCount() * quantity);
                    continue block6;
                }
                case 203: {
                    this.player.setCrystals(this.player.getCrystals() - cost.getCount() * quantity);
                    continue block6;
                }
                default: {
                    this.removeItem(this.getInventoryTab(ItemType.ITEM_MATERIAL).getItemById(cost.getId()), cost.getCount() * quantity);
                }
            }
        }
        if (reason != null) {
            // empty if block
        }
        return true;
    }

    public void removeItems(List<GameItem> items) {
        for (GameItem item : items) {
            this.removeItem(item, item.getCount());
        }
    }

    public boolean removeItem(long guid) {
        return this.removeItem(guid, 1);
    }

    public synchronized boolean removeItem(long guid, int count) {
        GameItem item = this.getItemByGuid(guid);
        if (item == null) {
            return false;
        }
        return this.removeItem(item, count);
    }

    public synchronized boolean removeItem(GameItem item) {
        return this.removeItem(item, item.getCount());
    }

    public synchronized boolean removeItem(GameItem item, int count) {
        if (count <= 0 || item == null) {
            return false;
        }
        if (item.getItemData().isEquip()) {
            item.setCount(0);
        } else {
            item.setCount(item.getCount() - count);
        }
        if (item.getCount() <= 0) {
            InventoryTab tab = null;
            if (item.getItemData() != null) {
                tab = this.getInventoryTab(item.getItemData().getItemType());
            }
            this.deleteItem(item, tab);
            this.getPlayer().sendPacket(new PacketStoreItemDelNotify(item));
        } else {
            this.getPlayer().sendPacket(new PacketStoreItemChangeNotify(item));
        }
        item.save();
        return true;
    }

    private void deleteItem(GameItem item, InventoryTab tab) {
        this.getItems().remove(item.getGuid());
        if (tab != null) {
            tab.onRemoveItem(item);
        }
    }

    public boolean equipItem(long avatarGuid, long equipGuid) {
        Avatar avatar = this.getPlayer().getAvatars().getAvatarByGuid(avatarGuid);
        GameItem item = this.getItemByGuid(equipGuid);
        if (avatar != null && item != null) {
            return avatar.equipItem(item, true);
        }
        return false;
    }

    public boolean unequipItem(long avatarGuid, int slot) {
        Avatar avatar = this.getPlayer().getAvatars().getAvatarByGuid(avatarGuid);
        EquipType equipType = EquipType.getTypeByValue(slot);
        if (avatar != null && equipType != EquipType.EQUIP_WEAPON && avatar.unequipItem(equipType)) {
            this.getPlayer().sendPacket(new PacketAvatarEquipChangeNotify(avatar, equipType));
            avatar.recalcStats();
            return true;
        }
        return false;
    }

    public void loadFromDatabase() {
        List<GameItem> items = DatabaseHelper.getInventoryItems(this.getPlayer());
        for (GameItem item : items) {
            ItemData itemData;
            if (item.getObjectId() == null || (itemData = (ItemData)GameData.getItemDataMap().get(item.getItemId())) == null) continue;
            item.setItemData(itemData);
            InventoryTab tab = null;
            if (item.getItemData() != null) {
                tab = this.getInventoryTab(item.getItemData().getItemType());
            }
            this.putItem(item, tab);
            if (!item.isEquipped()) continue;
            Avatar avatar = this.getPlayer().getAvatars().getAvatarById(item.getEquipCharacter());
            boolean hasEquipped = false;
            if (avatar != null) {
                hasEquipped = avatar.equipItem(item, false);
            }
            if (hasEquipped) continue;
            item.setEquipCharacter(0);
            item.save();
        }
    }

    @Override
    public Iterator<GameItem> iterator() {
        return this.getItems().values().iterator();
    }
}

