/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.expedition;

import com.google.gson.reflect.TypeToken;
import emu.grasscutter.Configuration;
import emu.grasscutter.Grasscutter;
import emu.grasscutter.game.expedition.ExpeditionRewardDataList;
import emu.grasscutter.game.expedition.ExpeditionRewardInfo;
import emu.grasscutter.server.game.GameServer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;

public class ExpeditionManager {
    private final GameServer gameServer;
    private final Int2ObjectMap<List<ExpeditionRewardDataList>> expeditionRewardData;

    public GameServer getGameServer() {
        return this.gameServer;
    }

    public Int2ObjectMap<List<ExpeditionRewardDataList>> getExpeditionRewardDataList() {
        return this.expeditionRewardData;
    }

    public ExpeditionManager(GameServer gameServer) {
        this.gameServer = gameServer;
        this.expeditionRewardData = new Int2ObjectOpenHashMap<List<ExpeditionRewardDataList>>();
        this.load();
    }

    public synchronized void load() {
        try (FileReader fileReader = new FileReader(Configuration.DATA("ExpeditionReward.json"));){
            this.getExpeditionRewardDataList().clear();
            List banners = (List)Grasscutter.getGsonFactory().fromJson((Reader)fileReader, TypeToken.getParameterized(Collection.class, new Type[]{ExpeditionRewardInfo.class}).getType());
            if (banners.size() > 0) {
                for (ExpeditionRewardInfo di : banners) {
                    this.getExpeditionRewardDataList().put(di.getExpId(), di.getExpeditionRewardDataList());
                }
                Grasscutter.getLogger().info("Expedition reward successfully loaded.");
            } else {
                Grasscutter.getLogger().error("Unable to load expedition reward. Expedition reward size is 0.");
            }
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Unable to load expedition reward.", e);
        }
    }
}

