/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.entity;

import emu.grasscutter.game.entity.EntityBaseGadget;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.EntityIdType;
import emu.grasscutter.game.props.PlayerProperty;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.net.proto.AbilitySyncStateInfoOuterClass;
import emu.grasscutter.net.proto.AnimatorParameterValueInfoPairOuterClass;
import emu.grasscutter.net.proto.EntityAuthorityInfoOuterClass;
import emu.grasscutter.net.proto.EntityRendererChangedInfoOuterClass;
import emu.grasscutter.net.proto.FightPropPairOuterClass;
import emu.grasscutter.net.proto.MotionInfoOuterClass;
import emu.grasscutter.net.proto.PropPairOuterClass;
import emu.grasscutter.net.proto.ProtEntityTypeOuterClass;
import emu.grasscutter.net.proto.SceneEntityAiInfoOuterClass;
import emu.grasscutter.net.proto.SceneEntityInfoOuterClass;
import emu.grasscutter.net.proto.SceneGadgetInfoOuterClass;
import emu.grasscutter.net.proto.VectorOuterClass;
import emu.grasscutter.net.proto.VehicleInfoOuterClass;
import emu.grasscutter.net.proto.VehicleMemberOuterClass;
import emu.grasscutter.utils.Position;
import emu.grasscutter.utils.ProtoHelper;
import it.unimi.dsi.fastutil.ints.Int2FloatMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class EntityVehicle
extends EntityBaseGadget {
    private final Player owner;
    private final Int2FloatOpenHashMap fightProp;
    private final Position pos;
    private final Position rot;
    private final int pointId;
    private final int gadgetId;
    private float curStamina;
    private List<VehicleMemberOuterClass.VehicleMember> vehicleMembers;

    public EntityVehicle(Scene scene, Player player, int gadgetId, int pointId, Position pos, Position rot) {
        super(scene);
        this.owner = player;
        this.id = this.getScene().getWorld().getNextEntityId(EntityIdType.GADGET);
        this.fightProp = new Int2FloatOpenHashMap();
        this.pos = new Position(pos);
        this.rot = new Position(rot);
        this.gadgetId = gadgetId;
        this.pointId = pointId;
        this.curStamina = 240.0f;
        this.vehicleMembers = new ArrayList<VehicleMemberOuterClass.VehicleMember>();
    }

    @Override
    public int getGadgetId() {
        return this.gadgetId;
    }

    public Player getOwner() {
        return this.owner;
    }

    public float getCurStamina() {
        return this.curStamina;
    }

    public void setCurStamina(float stamina) {
        this.curStamina = stamina;
    }

    public int getPointId() {
        return this.pointId;
    }

    public List<VehicleMemberOuterClass.VehicleMember> getVehicleMembers() {
        return this.vehicleMembers;
    }

    @Override
    public Int2FloatOpenHashMap getFightProperties() {
        return this.fightProp;
    }

    @Override
    public Position getPosition() {
        return this.pos;
    }

    @Override
    public Position getRotation() {
        return this.rot;
    }

    @Override
    public SceneEntityInfoOuterClass.SceneEntityInfo toProto() {
        VehicleInfoOuterClass.VehicleInfo vehicle = VehicleInfoOuterClass.VehicleInfo.newBuilder().setOwnerUid(this.owner.getUid()).setCurStamina(this.getCurStamina()).build();
        EntityAuthorityInfoOuterClass.EntityAuthorityInfo authority = EntityAuthorityInfoOuterClass.EntityAuthorityInfo.newBuilder().setAbilityInfo(AbilitySyncStateInfoOuterClass.AbilitySyncStateInfo.newBuilder()).setRendererChangedInfo(EntityRendererChangedInfoOuterClass.EntityRendererChangedInfo.newBuilder()).setAiInfo(SceneEntityAiInfoOuterClass.SceneEntityAiInfo.newBuilder().setIsAiOpen(true).setBornPos(this.getPosition().toProto())).setBornPos(this.getPosition().toProto()).build();
        SceneGadgetInfoOuterClass.SceneGadgetInfo.Builder gadgetInfo = SceneGadgetInfoOuterClass.SceneGadgetInfo.newBuilder().setGadgetId(this.getGadgetId()).setAuthorityPeerId(this.getOwner().getPeerId()).setIsEnableInteract(true).setVehicleInfo(vehicle);
        SceneEntityInfoOuterClass.SceneEntityInfo.Builder entityInfo = SceneEntityInfoOuterClass.SceneEntityInfo.newBuilder().setEntityId(this.getId()).setEntityType(ProtEntityTypeOuterClass.ProtEntityType.PROT_ENTITY_GADGET).setMotionInfo(MotionInfoOuterClass.MotionInfo.newBuilder().setPos(this.getPosition().toProto()).setRot(this.getRotation().toProto()).setSpeed(VectorOuterClass.Vector.newBuilder())).addAnimatorParaList(AnimatorParameterValueInfoPairOuterClass.AnimatorParameterValueInfoPair.newBuilder()).setGadget(gadgetInfo).setEntityAuthorityInfo(authority).setLifeState(1);
        PropPairOuterClass.PropPair pair = PropPairOuterClass.PropPair.newBuilder().setType(PlayerProperty.PROP_LEVEL.getId()).setPropValue(ProtoHelper.newPropValue(PlayerProperty.PROP_LEVEL, 47)).build();
        for (Int2FloatMap.Entry entry : this.getFightProperties().int2FloatEntrySet()) {
            if (entry.getIntKey() == 0) continue;
            FightPropPairOuterClass.FightPropPair fightProp = FightPropPairOuterClass.FightPropPair.newBuilder().setPropType(entry.getIntKey()).setPropValue(entry.getFloatValue()).build();
            entityInfo.addFightPropList(fightProp);
        }
        entityInfo.addPropList(pair);
        return entityInfo.build();
    }
}

