/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game.combine;

import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.CombineData;
import emu.grasscutter.game.combine.CombineResult;
import emu.grasscutter.game.inventory.GameItem;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.server.packet.send.PacketCombineRsp;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;

public class CombineManger {
    private final GameServer gameServer;

    public GameServer getGameServer() {
        return this.gameServer;
    }

    public CombineManger(GameServer gameServer) {
        this.gameServer = gameServer;
    }

    public CombineResult combineItem(Player player, int cid, int count) {
        if (!GameData.getCombineDataMap().containsKey(cid)) {
            player.getWorld().getHost().sendPacket(new PacketCombineRsp());
            return null;
        }
        CombineData combineData = (CombineData)GameData.getCombineDataMap().get(cid);
        if (combineData.getPlayerLevel() > player.getLevel()) {
            return null;
        }
        boolean enough = combineData.getMaterialItems().stream().filter(item -> player.getInventory().getInventoryTab(ItemType.ITEM_MATERIAL).getItemById(item.getId()).getCount() < item.getCount() * count).findAny().isEmpty();
        if (!enough) {
            player.getWorld().getHost().sendPacket(new PacketCombineRsp(700));
            return null;
        }
        if (player.getMora() < combineData.getScoinCost()) {
            return null;
        }
        player.setMora(player.getMora() - combineData.getScoinCost() * count);
        combineData.getMaterialItems().stream().map(item -> Pair.of(player.getInventory().getInventoryTab(ItemType.ITEM_MATERIAL).getItemById(item.getId()), item.getCount() * count)).forEach(item -> player.getInventory().removeItem((GameItem)item.first(), (int)((Integer)item.second())));
        player.getInventory().addItem(combineData.getResultItemId(), combineData.getResultItemCount() * count);
        CombineResult result = new CombineResult();
        result.setMaterial(List.of());
        result.setResult(List.of(new CombineData.CombineItemPair(combineData.getResultItemId(), combineData.getResultItemCount() * count)));
        result.setExtra(List.of());
        result.setBack(List.of());
        return result;
    }
}

