/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.game;

import dev.morphia.annotations.AlsoLoad;
import dev.morphia.annotations.Collation;
import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.PreLoad;
import emu.grasscutter.Configuration;
import emu.grasscutter.database.DatabaseHelper;
import emu.grasscutter.utils.Crypto;
import emu.grasscutter.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bson.Document;

@Entity(value="accounts", useDiscriminator=false)
public class Account {
    @Id
    private String id;
    @Indexed(options=@IndexOptions(unique=true))
    @Collation(locale="simple", caseLevel=true)
    private String username;
    private String password;
    @AlsoLoad(value={"playerUid"})
    private int playerId;
    private String email;
    private String token;
    private String sessionKey;
    private List<String> permissions = new ArrayList<String>();
    private Locale locale = Configuration.LANGUAGE;

    @Deprecated
    public Account() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getPlayerUid() {
        return this.playerId;
    }

    public void setPlayerId(int playerId) {
        this.playerId = playerId;
    }

    public String getEmail() {
        if (this.email != null && !this.email.isEmpty()) {
            return this.email;
        }
        return "";
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public String generateSessionKey() {
        this.sessionKey = Utils.bytesToHex(Crypto.createSessionKey(32));
        this.save();
        return this.sessionKey;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public boolean addPermission(String permission) {
        if (this.permissions.contains(permission)) {
            return false;
        }
        this.permissions.add(permission);
        return true;
    }

    public static boolean permissionMatchesWildcard(String wildcard, String[] permissionParts) {
        String[] wildcardParts = wildcard.split("\\.");
        if (permissionParts.length < wildcardParts.length) {
            return false;
        }
        block8: for (int i2 = 0; i2 < wildcardParts.length; ++i2) {
            switch (wildcardParts[i2]) {
                case "**": {
                    return true;
                }
                case "*": {
                    if (i2 < permissionParts.length - 1) continue block8;
                    return true;
                }
                default: {
                    if (wildcardParts[i2].equals(permissionParts[i2])) continue block8;
                    return false;
                }
            }
        }
        return wildcardParts.length == permissionParts.length;
    }

    public boolean hasPermission(String permission) {
        if (this.permissions.contains(permission)) {
            return true;
        }
        if (this.permissions.contains("*") && this.permissions.size() == 1) {
            return true;
        }
        String[] permissionParts = permission.split("\\.");
        for (String p : this.permissions) {
            if (p.startsWith("-") && Account.permissionMatchesWildcard(p.substring(1), permissionParts)) {
                return false;
            }
            if (!Account.permissionMatchesWildcard(p, permissionParts)) continue;
            return true;
        }
        return this.permissions.contains("*");
    }

    public boolean removePermission(String permission) {
        return this.permissions.remove(permission);
    }

    public String generateLoginToken() {
        this.token = Utils.bytesToHex(Crypto.createSessionKey(32));
        this.save();
        return this.token;
    }

    public void save() {
        DatabaseHelper.saveAccount(this);
    }

    @PreLoad
    public void onLoad(Document document) {
        if (!document.containsKey("permissions")) {
            this.addPermission("*");
        }
        if (!document.containsKey("locale")) {
            this.locale = Configuration.LANGUAGE;
        }
    }
}

