/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.data.def;

import emu.grasscutter.data.GameResource;
import emu.grasscutter.data.ResourceType;
import emu.grasscutter.data.common.FightPropData;
import emu.grasscutter.data.common.ItemParamData;
import java.util.ArrayList;

@ResourceType(name={"WeaponPromoteExcelConfigData.json"})
public class WeaponPromoteData
extends GameResource {
    private int WeaponPromoteId;
    private int PromoteLevel;
    private ItemParamData[] CostItems;
    private int CoinCost;
    private FightPropData[] AddProps;
    private int UnlockMaxLevel;
    private int RequiredPlayerLevel;

    @Override
    public int getId() {
        return (this.WeaponPromoteId << 8) + this.PromoteLevel;
    }

    public int getWeaponPromoteId() {
        return this.WeaponPromoteId;
    }

    public int getPromoteLevel() {
        return this.PromoteLevel;
    }

    public ItemParamData[] getCostItems() {
        return this.CostItems;
    }

    public int getCoinCost() {
        return this.CoinCost;
    }

    public FightPropData[] getAddProps() {
        return this.AddProps;
    }

    public int getUnlockMaxLevel() {
        return this.UnlockMaxLevel;
    }

    public int getRequiredPlayerLevel() {
        return this.RequiredPlayerLevel;
    }

    @Override
    public void onLoad() {
        ArrayList<ItemParamData> trim = new ArrayList<ItemParamData>(this.getAddProps().length);
        for (ItemParamData itemParam : this.getCostItems()) {
            if (itemParam.getId() == 0) continue;
            trim.add(itemParam);
        }
        this.CostItems = trim.toArray(new ItemParamData[trim.size()]);
        ArrayList<FightPropData> parsed = new ArrayList<FightPropData>(this.getAddProps().length);
        for (FightPropData prop : this.getAddProps()) {
            if (prop.getPropType() == null || prop.getValue() == 0.0f) continue;
            prop.onLoad();
            parsed.add(prop);
        }
        this.AddProps = parsed.toArray(new FightPropData[parsed.size()]);
    }
}

