/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.data.def;

import emu.grasscutter.data.GameResource;
import emu.grasscutter.data.ResourceType;
import emu.grasscutter.game.props.FightProperty;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;

@ResourceType(name={"ReliquaryLevelExcelConfigData.json"})
public class ReliquaryLevelData
extends GameResource {
    private int id;
    private Int2ObjectMap<Float> propMap;
    private int Rank;
    private int Level;
    private int Exp;
    private List<RelicLevelProperty> AddProps;

    @Override
    public int getId() {
        return this.id;
    }

    public int getRank() {
        return this.Rank;
    }

    public int getLevel() {
        return this.Level;
    }

    public int getExp() {
        return this.Exp;
    }

    public float getPropValue(FightProperty prop) {
        return this.getPropValue(prop.getId());
    }

    public float getPropValue(int id) {
        return ((Float)this.propMap.get(id)).floatValue();
    }

    @Override
    public void onLoad() {
        this.id = (this.Rank << 8) + this.getLevel();
        this.propMap = new Int2ObjectOpenHashMap<Float>();
        for (RelicLevelProperty p : this.AddProps) {
            this.propMap.put(FightProperty.getPropByName(p.getPropType()).getId(), Float.valueOf(p.getValue()));
        }
    }

    public class RelicLevelProperty {
        private String PropType;
        private float Value;

        public String getPropType() {
            return this.PropType;
        }

        public float getValue() {
            return this.Value;
        }
    }
}

