/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.data.def;

import emu.grasscutter.data.GameResource;
import emu.grasscutter.data.ResourceType;
import emu.grasscutter.game.inventory.EquipType;
import emu.grasscutter.game.inventory.ItemType;
import emu.grasscutter.game.inventory.MaterialType;
import emu.grasscutter.game.props.FightProperty;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;

@ResourceType(name={"MaterialExcelConfigData.json", "WeaponExcelConfigData.json", "ReliquaryExcelConfigData.json"})
public class ItemData
extends GameResource {
    private int Id;
    private int StackLimit = 1;
    private int MaxUseCount;
    private int RankLevel;
    private String EffectName;
    private int[] SatiationParams;
    private int Rank;
    private int Weight;
    private int GadgetId;
    private int[] DestroyReturnMaterial;
    private int[] DestroyReturnMaterialCount;
    private String FoodQuality;
    private String UseTarget;
    private String[] UseParam;
    private String ItemType;
    private String MaterialType;
    private String EquipType;
    private String EffectType;
    private String DestroyRule;
    private int MainPropDepotId;
    private int AppendPropDepotId;
    private int AppendPropNum;
    private int SetId;
    private int[] AddPropLevels;
    private int BaseConvExp;
    private int MaxLevel;
    private int WeaponPromoteId;
    private int WeaponBaseExp;
    private int StoryId;
    private int AvatarPromoteId;
    private int AwakenMaterial;
    private int[] AwakenCosts;
    private int[] SkillAffix;
    private WeaponProperty[] WeaponProp;
    private String Icon;
    private long NameTextMapHash;
    private transient MaterialType materialType;
    private transient ItemType itemType;
    private transient EquipType equipType;
    private IntSet addPropLevelSet;

    @Override
    public int getId() {
        return this.Id;
    }

    public String getMaterialTypeString() {
        return this.MaterialType;
    }

    public int getStackLimit() {
        return this.StackLimit;
    }

    public int getMaxUseCount() {
        return this.MaxUseCount;
    }

    public String getUseTarget() {
        return this.UseTarget;
    }

    public String[] getUseParam() {
        return this.UseParam;
    }

    public int getRankLevel() {
        return this.RankLevel;
    }

    public String getFoodQuality() {
        return this.FoodQuality;
    }

    public String getEffectName() {
        return this.EffectName;
    }

    public int[] getSatiationParams() {
        return this.SatiationParams;
    }

    public int[] getDestroyReturnMaterial() {
        return this.DestroyReturnMaterial;
    }

    public int[] getDestroyReturnMaterialCount() {
        return this.DestroyReturnMaterialCount;
    }

    public long getNameTextMapHash() {
        return this.NameTextMapHash;
    }

    public String getIcon() {
        return this.Icon;
    }

    public String getItemTypeString() {
        return this.ItemType;
    }

    public int getRank() {
        return this.Rank;
    }

    public int getGadgetId() {
        return this.GadgetId;
    }

    public int getBaseConvExp() {
        return this.BaseConvExp;
    }

    public int getMainPropDepotId() {
        return this.MainPropDepotId;
    }

    public int getAppendPropDepotId() {
        return this.AppendPropDepotId;
    }

    public int getAppendPropNum() {
        return this.AppendPropNum;
    }

    public int getSetId() {
        return this.SetId;
    }

    public int getWeaponPromoteId() {
        return this.WeaponPromoteId;
    }

    public int getWeaponBaseExp() {
        return this.WeaponBaseExp;
    }

    public int getAwakenMaterial() {
        return this.AwakenMaterial;
    }

    public int[] getAwakenCosts() {
        return this.AwakenCosts;
    }

    public IntSet getAddPropLevelSet() {
        return this.addPropLevelSet;
    }

    public int[] getSkillAffix() {
        return this.SkillAffix;
    }

    public WeaponProperty[] getWeaponProperties() {
        return this.WeaponProp;
    }

    public int getMaxLevel() {
        return this.MaxLevel;
    }

    public ItemType getItemType() {
        return this.itemType;
    }

    public MaterialType getMaterialType() {
        return this.materialType;
    }

    public EquipType getEquipType() {
        return this.equipType;
    }

    public boolean canAddRelicProp(int level) {
        return this.addPropLevelSet != null & this.addPropLevelSet.contains(level);
    }

    public boolean isEquip() {
        return this.itemType == emu.grasscutter.game.inventory.ItemType.ITEM_RELIQUARY || this.itemType == emu.grasscutter.game.inventory.ItemType.ITEM_WEAPON;
    }

    @Override
    public void onLoad() {
        this.itemType = emu.grasscutter.game.inventory.ItemType.getTypeByName(this.getItemTypeString());
        this.materialType = emu.grasscutter.game.inventory.MaterialType.getTypeByName(this.getMaterialTypeString());
        if (this.itemType == emu.grasscutter.game.inventory.ItemType.ITEM_RELIQUARY) {
            this.equipType = emu.grasscutter.game.inventory.EquipType.getTypeByName(this.EquipType);
            if (this.AddPropLevels != null && this.AddPropLevels.length > 0) {
                this.addPropLevelSet = new IntOpenHashSet(this.AddPropLevels);
            }
        } else {
            this.equipType = this.itemType == emu.grasscutter.game.inventory.ItemType.ITEM_WEAPON ? emu.grasscutter.game.inventory.EquipType.EQUIP_WEAPON : emu.grasscutter.game.inventory.EquipType.EQUIP_NONE;
        }
        if (this.getWeaponProperties() != null) {
            for (WeaponProperty weaponProperty : this.getWeaponProperties()) {
                weaponProperty.onLoad();
            }
        }
    }

    public static class WeaponProperty {
        private FightProperty fightProp;
        private String PropType;
        private float InitValue;
        private String Type;

        public String getPropType() {
            return this.PropType;
        }

        public float getInitValue() {
            return this.InitValue;
        }

        public String getType() {
            return this.Type;
        }

        public FightProperty getFightProp() {
            return this.fightProp;
        }

        public void onLoad() {
            this.fightProp = FightProperty.getPropByName(this.PropType);
        }
    }
}

