/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.ClimateType;
import emu.grasscutter.server.packet.send.PacketSceneAreaWeatherNotify;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="weather", usage="weather <weatherId> [climateId]", aliases={"w"}, permission="player.weather", permissionTargeted="player.weather.others", description="commands.weather.description")
public final class WeatherCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        int weatherId = 0;
        int climateId = 1;
        switch (args2.size()) {
            case 2: {
                try {
                    climateId = Integer.parseInt(args2.get(1));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.weather.invalid_id", new Object[0]));
                }
            }
            case 1: {
                try {
                    weatherId = Integer.parseInt(args2.get(0));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.weather.invalid_id", new Object[0]));
                }
                break;
            }
            default: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.weather.usage", new Object[0]));
                return;
            }
        }
        ClimateType climate = ClimateType.getTypeByValue(climateId);
        targetPlayer.getScene().setWeather(weatherId);
        targetPlayer.getScene().setClimate(climate);
        targetPlayer.getScene().broadcastPacket(new PacketSceneAreaWeatherNotify(targetPlayer));
        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.weather.success", Integer.toString(weatherId), Integer.toString(climateId)));
    }
}

