/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import emu.grasscutter.utils.Position;
import java.util.List;

@Command(label="tpall", usage="tpall", permission="player.tpall", permissionTargeted="player.tpall.others", description="commands.teleportAll.description")
public final class TeleportAllCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        if (!targetPlayer.getWorld().isMultiplayer()) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.teleportAll.error", new Object[0]));
            return;
        }
        for (Player player : targetPlayer.getWorld().getPlayers()) {
            if (player.equals(targetPlayer)) continue;
            Position pos = targetPlayer.getPos();
            player.getWorld().transferPlayerToScene(player, targetPlayer.getSceneId(), pos);
        }
        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.teleportAll.success", new Object[0]));
    }
}

