/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.def.AvatarSkillDepotData;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.entity.EntityAvatar;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.server.packet.send.PacketAvatarSkillChangeNotify;
import emu.grasscutter.server.packet.send.PacketAvatarSkillUpgradeRsp;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="talent", usage="talent <talentID> <value>", permission="player.settalent", permissionTargeted="player.settalent.others", description="commands.talent.description")
public final class TalentCommand
implements CommandHandler {
    private void setTalentLevel(Player sender, Player player, Avatar avatar, int talentId, int talentLevel) {
        int oldLevel = avatar.getSkillLevelMap().get(talentId);
        if (talentLevel < 0 || talentLevel > 15) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.lower_16", new Object[0]));
            return;
        }
        avatar.getSkillLevelMap().put(talentId, talentLevel);
        avatar.save();
        player.sendPacket(new PacketAvatarSkillChangeNotify(avatar, talentId, oldLevel, talentLevel));
        player.sendPacket(new PacketAvatarSkillUpgradeRsp(avatar, talentId, oldLevel, talentLevel));
        String successMessage = "commands.talent.set_id";
        AvatarSkillDepotData depot = avatar.getData().getSkillDepot();
        if (talentId == depot.getSkills().get(0)) {
            successMessage = "commands.talent.set_atk";
        } else if (talentId == depot.getSkills().get(1)) {
            successMessage = "commands.talent.set_e";
        } else if (talentId == depot.getEnergySkill()) {
            successMessage = "commands.talent.set_q";
        }
        CommandHandler.sendMessage(sender, Language.translate(sender, successMessage, talentLevel));
    }

    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        String cmdSwitch;
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        if (args2.size() < 1) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.usage_1", new Object[0]));
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.usage_2", new Object[0]));
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.usage_3", new Object[0]));
            return;
        }
        EntityAvatar entity = targetPlayer.getTeamManager().getCurrentAvatarEntity();
        Avatar avatar = entity.getAvatar();
        switch (cmdSwitch = args2.get(0)) {
            default: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.usage_1", new Object[0]));
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.usage_2", new Object[0]));
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.usage_3", new Object[0]));
                return;
            }
            case "set": {
                if (args2.size() < 3) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.usage_1", new Object[0]));
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.usage_3", new Object[0]));
                    return;
                }
                try {
                    int skillId = Integer.parseInt(args2.get(1));
                    int newLevel = Integer.parseInt(args2.get(2));
                    this.setTalentLevel(sender, targetPlayer, avatar, skillId, newLevel);
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.invalid_skill_id", new Object[0]));
                    return;
                }
            }
            case "n": 
            case "e": 
            case "q": {
                if (args2.size() < 2) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.usage_2", new Object[0]));
                    return;
                }
                AvatarSkillDepotData SkillDepot = avatar.getData().getSkillDepot();
                int skillId = switch (cmdSwitch) {
                    default -> SkillDepot.getSkills().get(0);
                    case "e" -> SkillDepot.getSkills().get(1);
                    case "q" -> SkillDepot.getEnergySkill();
                };
                try {
                    int newLevel = Integer.parseInt(args2.get(1));
                    this.setTalentLevel(sender, targetPlayer, avatar, skillId, newLevel);
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.invalid_level", new Object[0]));
                    return;
                }
            }
            case "getid": {
                int skillIdNorAtk = avatar.getData().getSkillDepot().getSkills().get(0);
                int skillIdE = avatar.getData().getSkillDepot().getSkills().get(1);
                int skillIdQ = avatar.getData().getSkillDepot().getEnergySkill();
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.normal_attack_id", Integer.toString(skillIdNorAtk)));
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.e_skill_id", Integer.toString(skillIdE)));
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.talent.q_skill_id", Integer.toString(skillIdQ)));
            }
        }
    }
}

