/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.GadgetData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.data.def.MonsterData;
import emu.grasscutter.game.entity.EntityItem;
import emu.grasscutter.game.entity.EntityMonster;
import emu.grasscutter.game.entity.EntityVehicle;
import emu.grasscutter.game.entity.GameEntity;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.game.props.FightProperty;
import emu.grasscutter.game.world.Scene;
import emu.grasscutter.utils.Language;
import emu.grasscutter.utils.Position;
import java.util.List;

@Command(label="spawn", usage="spawn <entityId> [amount] [level(monster only)]", permission="server.spawn", permissionTargeted="server.spawn.others", description="commands.spawn.description")
public final class SpawnCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        int id = 0;
        int amount = 1;
        int level = 1;
        switch (args2.size()) {
            case 3: {
                try {
                    level = Integer.parseInt(args2.get(2));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.argument_error", new Object[0]));
                }
            }
            case 2: {
                try {
                    amount = Integer.parseInt(args2.get(1));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.amount", new Object[0]));
                }
            }
            case 1: {
                try {
                    id = Integer.parseInt(args2.get(0));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.entityId", new Object[0]));
                }
                break;
            }
            default: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.spawn.usage", new Object[0]));
                return;
            }
        }
        MonsterData monsterData = (MonsterData)GameData.getMonsterDataMap().get(id);
        GadgetData gadgetData = (GadgetData)GameData.getGadgetDataMap().get(id);
        ItemData itemData = (ItemData)GameData.getItemDataMap().get(id);
        if (monsterData == null && gadgetData == null && itemData == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.entityId", new Object[0]));
            return;
        }
        Scene scene = targetPlayer.getScene();
        double maxRadius = Math.sqrt((double)amount * 0.2 / Math.PI);
        for (int i2 = 0; i2 < amount; ++i2) {
            Position pos = this.GetRandomPositionInCircle(targetPlayer.getPos(), maxRadius).addY(3.0f);
            GameEntity entity = null;
            if (itemData != null) {
                entity = new EntityItem(scene, null, itemData, pos, 1, true);
            }
            if (gadgetData != null) {
                entity = new EntityVehicle(scene, targetPlayer.getSession().getPlayer(), gadgetData.getId(), 0, pos, targetPlayer.getRotation());
                int gadgetId = gadgetData.getId();
                switch (gadgetId) {
                    case 45001001: 
                    case 45001002: {
                        entity.addFightProperty(FightProperty.FIGHT_PROP_BASE_HP, 10000.0f);
                        entity.addFightProperty(FightProperty.FIGHT_PROP_BASE_ATTACK, 100.0f);
                        entity.addFightProperty(FightProperty.FIGHT_PROP_CUR_ATTACK, 100.0f);
                        entity.addFightProperty(FightProperty.FIGHT_PROP_CUR_HP, 10000.0f);
                        entity.addFightProperty(FightProperty.FIGHT_PROP_CUR_DEFENSE, 0.0f);
                        entity.addFightProperty(FightProperty.FIGHT_PROP_CUR_SPEED, 0.0f);
                        entity.addFightProperty(FightProperty.FIGHT_PROP_CHARGE_EFFICIENCY, 0.0f);
                        entity.addFightProperty(FightProperty.FIGHT_PROP_MAX_HP, 10000.0f);
                        break;
                    }
                }
            }
            if (monsterData != null) {
                entity = new EntityMonster(scene, monsterData, pos, level);
            }
            scene.addEntity(entity);
        }
        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.spawn.success", Integer.toString(amount), Integer.toString(id)));
    }

    private Position GetRandomPositionInCircle(Position origin, double radius) {
        Position target = origin.clone();
        double angle = Math.random() * 360.0;
        double r = Math.sqrt(Math.random() * radius * radius);
        target.addX((float)(r * Math.cos(angle))).addZ((float)(r * Math.sin(angle)));
        return target;
    }
}

