/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="setworldlevel", usage="setworldlevel <level>", aliases={"setworldlvl"}, permission="player.setworldlevel", permissionTargeted="player.setworldlevel.others", description="commands.setWorldLevel.description")
public final class SetWorldLevelCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        if (args2.size() < 1) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.setWorldLevel.usage", new Object[0]));
            return;
        }
        try {
            int level = Integer.parseInt(args2.get(0));
            if (level > 8 || level < 0) {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.setWorldLevel.value_error", new Object[0]));
                return;
            }
            targetPlayer.getWorld().setWorldLevel(level);
            targetPlayer.setWorldLevel(level);
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.setWorldLevel.success", Integer.toString(level)));
        }
        catch (NumberFormatException ignored) {
            CommandHandler.sendMessage(null, Language.translate(sender, "commands.setWorldLevel.invalid_world_level", new Object[0]));
        }
    }
}

