/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.server.packet.send.PacketChangeMpTeamAvatarRsp;
import emu.grasscutter.utils.Language;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Command(label="remove", usage="remove [indexOfYourTeams] index start from 1", description="commands.remove.description", permission="player.remove")
public class RemoveCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        ArrayList<Integer> avatarIndexList = new ArrayList<Integer>();
        for (String arg : args2) {
            try {
                int avatarIndex = Integer.parseInt(arg);
                if (avatarIndexList.contains(avatarIndex)) continue;
                avatarIndexList.add(avatarIndex);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
                CommandHandler.sendMessage(sender, Language.translate("commands.remove.invalid_index", new Object[0]));
                return;
            }
        }
        Collections.sort(avatarIndexList, Collections.reverseOrder());
        for (int i2 = 0; i2 < avatarIndexList.size(); ++i2) {
            if ((Integer)avatarIndexList.get(i2) > targetPlayer.getTeamManager().getCurrentTeamInfo().getAvatars().size() || (Integer)avatarIndexList.get(i2) <= 0) {
                CommandHandler.sendMessage(targetPlayer, Language.translate("commands.remove.invalid_index", new Object[0]));
                return;
            }
            targetPlayer.getTeamManager().getCurrentTeamInfo().removeAvatar((Integer)avatarIndexList.get(i2) - 1);
        }
        targetPlayer.getTeamManager().updateTeamEntities(new PacketChangeMpTeamAvatarRsp(targetPlayer, targetPlayer.getTeamManager().getCurrentTeamInfo()));
    }
}

