/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="permission", usage="permission <add|remove> <permission>", permission="permission", description="commands.permission.description")
public final class PermissionCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        if (args2.size() != 2) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.permission.usage", new Object[0]));
            return;
        }
        String action = args2.get(0);
        String permission = args2.get(1);
        Account account = targetPlayer.getAccount();
        if (account == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.permission.account_error", new Object[0]));
            return;
        }
        switch (action) {
            default: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.permission.usage", new Object[0]));
                break;
            }
            case "add": {
                if (account.addPermission(permission)) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.permission.add", new Object[0]));
                    break;
                }
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.permission.has_error", new Object[0]));
                break;
            }
            case "remove": {
                if (account.removePermission(permission)) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.permission.remove", new Object[0]));
                    break;
                }
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.permission.not_have_error", new Object[0]));
            }
        }
        account.save();
    }
}

