/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.ConfigContainer;
import emu.grasscutter.utils.Language;
import emu.grasscutter.utils.Utils;
import java.util.List;
import java.util.Locale;

@Command(label="language", usage="language [language code]", description="commands.language.description", aliases={"lang"})
public final class LanguageCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (args2.isEmpty()) {
            String curLangCode = null;
            curLangCode = sender != null ? Utils.getLanguageCode(sender.getAccount().getLocale()) : Grasscutter.getLanguage().getLanguageCode();
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.language.current_language", curLangCode));
            return;
        }
        String langCode = args2.get(0);
        Language languageInst = Grasscutter.getLanguage(langCode);
        String actualLangCode = languageInst.getLanguageCode();
        Locale locale = Locale.forLanguageTag(actualLangCode);
        if (sender != null) {
            Account account = sender.getAccount();
            account.setLocale(locale);
            account.save();
        } else {
            Grasscutter.setLanguage(languageInst);
            ConfigContainer config = Grasscutter.getConfig();
            config.language.language = locale;
            Grasscutter.saveConfig(config);
        }
        if (!langCode.equals(actualLangCode)) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.language.language_not_found", langCode));
        }
        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.language.language_changed", actualLangCode));
    }
}

