/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.avatar.Avatar;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.server.packet.send.PacketChangeMpTeamAvatarRsp;
import emu.grasscutter.utils.Language;
import java.util.ArrayList;
import java.util.List;

@Command(label="join", usage="join [AvatarIDs] such as\"join 10000038 10000039\"", description="commands.join.description", permission="player.join")
public class JoinCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        ArrayList<Integer> avatarIds = new ArrayList<Integer>();
        for (String arg : args2) {
            try {
                int avatarId = Integer.parseInt(arg);
                avatarIds.add(avatarId);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
                CommandHandler.sendMessage(sender, Language.translate("commands.generic.invalid.avatarId", new Object[0]));
                return;
            }
        }
        for (int i2 = 0; i2 < args2.size(); ++i2) {
            Avatar avatar = targetPlayer.getAvatars().getAvatarById((Integer)avatarIds.get(i2));
            if (avatar == null) {
                CommandHandler.sendMessage(sender, Language.translate("commands.generic.invalid.avatarId", new Object[0]));
                return;
            }
            if (targetPlayer.getTeamManager().getCurrentTeamInfo().contains(avatar)) continue;
            targetPlayer.getTeamManager().getCurrentTeamInfo().addAvatar(avatar);
        }
        targetPlayer.getTeamManager().updateTeamEntities(new PacketChangeMpTeamAvatarRsp(targetPlayer, targetPlayer.getTeamManager().getCurrentTeamInfo()));
    }
}

