/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="enterdungeon", usage="enterdungeon <dungeon id>", aliases={"dungeon"}, permission="player.enterdungeon", permissionTargeted="player.enterdungeon.others", description="commands.enter_dungeon.description")
public final class EnterDungeonCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(null, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        if (args2.size() < 1) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.enter_dungeon.usage", new Object[0]));
            return;
        }
        try {
            int dungeonId = Integer.parseInt(args2.get(0));
            if (dungeonId == targetPlayer.getSceneId()) {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.enter_dungeon.in_dungeon_error", new Object[0]));
                return;
            }
            boolean result = targetPlayer.getServer().getDungeonManager().enterDungeon(targetPlayer.getSession().getPlayer(), 0, dungeonId);
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.enter_dungeon.changed", dungeonId));
            if (!result) {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.enter_dungeon.not_found_error", new Object[0]));
            }
        }
        catch (Exception e) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.enter_dungeon.usage", new Object[0]));
        }
    }
}

