/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.data.GameData;
import emu.grasscutter.data.def.ItemData;
import emu.grasscutter.game.entity.EntityItem;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import emu.grasscutter.utils.Position;
import java.util.List;

@Command(label="drop", usage="drop <itemId|itemName> [amount]", aliases={"d", "dropitem"}, permission="server.drop", permissionTargeted="server.drop.others", description="commands.drop.description")
public final class DropCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(null, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        int item = 0;
        int amount = 1;
        switch (args2.size()) {
            case 2: {
                try {
                    amount = Integer.parseInt(args2.get(1));
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.amount", new Object[0]));
                    return;
                }
            }
            case 1: {
                try {
                    item = Integer.parseInt(args2.get(0));
                    break;
                }
                catch (NumberFormatException ignored) {
                    CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.itemId", new Object[0]));
                    return;
                }
            }
            default: {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.drop.command_usage", new Object[0]));
                return;
            }
        }
        ItemData itemData = (ItemData)GameData.getItemDataMap().get(item);
        if (itemData == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.generic.invalid.itemId", new Object[0]));
            return;
        }
        if (itemData.isEquip()) {
            float range = 5.0f + 0.1f * (float)amount;
            for (int i2 = 0; i2 < amount; ++i2) {
                Position pos = targetPlayer.getPos().clone().addX((float)(Math.random() * (double)range) - range / 2.0f).addY(3.0f).addZ((float)(Math.random() * (double)range) - range / 2.0f);
                EntityItem entity = new EntityItem(targetPlayer.getScene(), targetPlayer, itemData, pos, 1);
                targetPlayer.getScene().addEntity(entity);
            }
        } else {
            EntityItem entity = new EntityItem(targetPlayer.getScene(), targetPlayer, itemData, targetPlayer.getPos().clone().addY(3.0f), amount);
            targetPlayer.getScene().addEntity(entity);
        }
        CommandHandler.sendMessage(sender, Language.translate(sender, "commands.drop.success", Integer.toString(amount), Integer.toString(item)));
    }
}

