/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command.commands;

import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.List;

@Command(label="changescene", usage="changescene <scene id>", aliases={"scene"}, permission="player.changescene", permissionTargeted="player.changescene.others", description="commands.changescene.description")
public final class ChangeSceneCommand
implements CommandHandler {
    @Override
    public void execute(Player sender, Player targetPlayer, List<String> args2) {
        if (targetPlayer == null) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.need_target", new Object[0]));
            return;
        }
        if (args2.size() != 1) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.changescene.usage", new Object[0]));
            return;
        }
        try {
            int sceneId = Integer.parseInt(args2.get(0));
            if (sceneId == targetPlayer.getSceneId()) {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.changescene.already_in_scene", new Object[0]));
                return;
            }
            boolean result = targetPlayer.getWorld().transferPlayerToScene(targetPlayer, sceneId, targetPlayer.getPos());
            if (!result) {
                CommandHandler.sendMessage(sender, Language.translate(sender, "commands.changescene.exists_error", new Object[0]));
                return;
            }
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.changescene.success", Integer.toString(sceneId)));
        }
        catch (Exception e) {
            CommandHandler.sendMessage(sender, Language.translate(sender, "commands.execution.argument_error", new Object[0]));
        }
    }
}

