/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter.command;

import emu.grasscutter.Grasscutter;
import emu.grasscutter.command.Command;
import emu.grasscutter.command.CommandHandler;
import emu.grasscutter.game.Account;
import emu.grasscutter.game.player.Player;
import emu.grasscutter.utils.Language;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.Reflections;

public final class CommandMap {
    private final Map<String, CommandHandler> commands = new HashMap<String, CommandHandler>();
    private final Map<String, Command> annotations = new HashMap<String, Command>();
    private final Map<String, Integer> targetPlayerIds = new HashMap<String, Integer>();
    private static final String consoleId = "console";

    public CommandMap() {
        this(false);
    }

    public CommandMap(boolean scan2) {
        if (scan2) {
            this.scan();
        }
    }

    public static CommandMap getInstance() {
        return Grasscutter.getGameServer().getCommandMap();
    }

    public CommandMap registerCommand(String label, CommandHandler command) {
        Grasscutter.getLogger().debug("Registered command: " + label);
        Command annotation = command.getClass().getAnnotation(Command.class);
        this.annotations.put(label, annotation);
        this.commands.put(label, command);
        if (annotation.aliases().length > 0) {
            for (String alias : annotation.aliases()) {
                this.commands.put(alias, command);
                this.annotations.put(alias, annotation);
            }
        }
        return this;
    }

    public CommandMap unregisterCommand(String label) {
        Grasscutter.getLogger().debug("Unregistered command: " + label);
        CommandHandler handler = this.commands.get(label);
        if (handler == null) {
            return this;
        }
        Command annotation = handler.getClass().getAnnotation(Command.class);
        this.annotations.remove(label);
        this.commands.remove(label);
        if (annotation.aliases().length > 0) {
            for (String alias : annotation.aliases()) {
                this.commands.remove(alias);
                this.annotations.remove(alias);
            }
        }
        return this;
    }

    public List<Command> getAnnotationsAsList() {
        return new LinkedList<Command>(this.annotations.values());
    }

    public HashMap<String, Command> getAnnotations() {
        return new LinkedHashMap<String, Command>(this.annotations);
    }

    public List<CommandHandler> getHandlersAsList() {
        return new LinkedList<CommandHandler>(this.commands.values());
    }

    public HashMap<String, CommandHandler> getHandlers() {
        return new LinkedHashMap<String, CommandHandler>(this.commands);
    }

    public CommandHandler getHandler(String label) {
        return this.commands.get(label);
    }

    public void invoke(Player player, Player targetPlayer, String rawMessage) {
        if ((rawMessage = rawMessage.trim()).length() == 0) {
            CommandHandler.sendMessage(player, Language.translate("commands.generic.not_specified", new Object[0]));
            return;
        }
        String[] split = rawMessage.split(" ");
        LinkedList<String> args2 = new LinkedList<String>(Arrays.asList(split));
        String label = (String)args2.remove(0);
        String playerId = player == null ? consoleId : player.getAccount().getId();
        String targetUidStr = null;
        if (label.startsWith("@")) {
            targetUidStr = label.substring(1);
        } else if (label.equalsIgnoreCase("target")) {
            if (args2.size() > 0) {
                targetUidStr = (String)args2.get(0);
                if (targetUidStr.startsWith("@")) {
                    targetUidStr = targetUidStr.substring(1);
                }
            } else {
                targetUidStr = "";
            }
        }
        if (targetUidStr != null) {
            if (targetUidStr.equals("")) {
                this.targetPlayerIds.remove(playerId);
                CommandHandler.sendMessage(player, Language.translate("commands.execution.clear_target", new Object[0]));
            } else {
                try {
                    int uid = Integer.parseInt(targetUidStr);
                    targetPlayer = Grasscutter.getGameServer().getPlayerByUid(uid);
                    if (targetPlayer == null) {
                        CommandHandler.sendMessage(player, Language.translate("commands.execution.player_exist_offline_error", new Object[0]));
                    } else {
                        this.targetPlayerIds.put(playerId, uid);
                        CommandHandler.sendMessage(player, Language.translate("commands.execution.set_target", targetUidStr));
                    }
                }
                catch (NumberFormatException e) {
                    CommandHandler.sendMessage(player, Language.translate("commands.execution.uid_error", new Object[0]));
                }
            }
            return;
        }
        CommandHandler handler = this.commands.get(label);
        if (handler == null) {
            CommandHandler.sendMessage(player, Language.translate("commands.generic.unknown_command", label));
            return;
        }
        for (int i2 = 0; i2 < args2.size(); ++i2) {
            String arg = (String)args2.get(i2);
            if (!arg.startsWith("@")) continue;
            arg = ((String)args2.remove(i2)).substring(1);
            try {
                int uid = Integer.parseInt(arg);
                targetPlayer = Grasscutter.getGameServer().getPlayerByUid(uid);
                if (targetPlayer == null) {
                    CommandHandler.sendMessage(player, Language.translate("commands.execution.player_exist_offline_error", new Object[0]));
                    return;
                }
                break;
            }
            catch (NumberFormatException e) {
                CommandHandler.sendMessage(player, Language.translate("commands.execution.uid_error", new Object[0]));
                return;
            }
        }
        if (targetPlayer == null) {
            if (this.targetPlayerIds.containsKey(playerId)) {
                targetPlayer = Grasscutter.getGameServer().getPlayerByUid(this.targetPlayerIds.get(playerId));
                if (targetPlayer == null) {
                    CommandHandler.sendMessage(player, Language.translate("commands.execution.player_exist_offline_error", new Object[0]));
                    return;
                }
            } else {
                targetPlayer = player;
            }
        }
        if (player != null) {
            String permissionNode = this.annotations.get(label).permission();
            String permissionNodeTargeted = this.annotations.get(label).permissionTargeted();
            Account account = player.getAccount();
            if (player != targetPlayer && !permissionNodeTargeted.isEmpty() && !account.hasPermission(permissionNodeTargeted)) {
                CommandHandler.sendMessage(player, Language.translate("commands.generic.permission_error", new Object[0]));
                return;
            }
            if (!permissionNode.isEmpty() && !account.hasPermission(permissionNode)) {
                CommandHandler.sendMessage(player, Language.translate("commands.generic.permission_error", new Object[0]));
                return;
            }
        }
        boolean threading = this.annotations.get(label).threading();
        Player targetPlayerF = targetPlayer;
        Runnable runnable = () -> handler.execute(player, targetPlayerF, args2);
        if (threading) {
            new Thread(runnable).start();
        } else {
            runnable.run();
        }
    }

    private void scan() {
        Reflections reflector = Grasscutter.reflector;
        Set<Class<?>> classes = reflector.getTypesAnnotatedWith(Command.class);
        classes.forEach(annotated -> {
            try {
                Command cmdData = annotated.getAnnotation(Command.class);
                Object object = annotated.newInstance();
                if (object instanceof CommandHandler) {
                    this.registerCommand(cmdData.label(), (CommandHandler)object);
                } else {
                    Grasscutter.getLogger().error("Class " + annotated.getName() + " is not a CommandHandler!");
                }
            }
            catch (Exception exception) {
                Grasscutter.getLogger().error("Failed to register command handler for " + annotated.getSimpleName(), exception);
            }
        });
    }
}

