/*
 * Decompiled with CFR 0.152.
 */
package emu.grasscutter;

import ch.qos.logback.classic.Logger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import emu.grasscutter.Configuration;
import emu.grasscutter.auth.AuthenticationSystem;
import emu.grasscutter.auth.DefaultAuthentication;
import emu.grasscutter.command.CommandMap;
import emu.grasscutter.data.ResourceLoader;
import emu.grasscutter.database.DatabaseManager;
import emu.grasscutter.game.managers.StaminaManager.StaminaManager;
import emu.grasscutter.plugin.PluginManager;
import emu.grasscutter.plugin.api.ServerHook;
import emu.grasscutter.scripts.ScriptLoader;
import emu.grasscutter.server.game.GameServer;
import emu.grasscutter.server.http.HttpServer;
import emu.grasscutter.server.http.dispatch.DispatchHandler;
import emu.grasscutter.server.http.dispatch.RegionHandler;
import emu.grasscutter.server.http.handlers.AnnouncementsHandler;
import emu.grasscutter.server.http.handlers.GachaHandler;
import emu.grasscutter.server.http.handlers.GenericHandler;
import emu.grasscutter.server.http.handlers.LogHandler;
import emu.grasscutter.tools.Tools;
import emu.grasscutter.utils.ConfigContainer;
import emu.grasscutter.utils.Crypto;
import emu.grasscutter.utils.Language;
import emu.grasscutter.utils.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOError;
import java.io.IOException;
import java.io.Reader;
import java.util.Calendar;
import java.util.Locale;
import javax.annotation.Nullable;
import org.jline.reader.EndOfFileException;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.LoggerFactory;

public final class Grasscutter {
    private static final Logger log = (Logger)LoggerFactory.getLogger(Grasscutter.class);
    private static LineReader consoleLineReader = null;
    private static Language language;
    private static final Gson gson;
    public static final File configFile;
    private static int day;
    private static HttpServer httpServer;
    private static GameServer gameServer;
    private static PluginManager pluginManager;
    private static AuthenticationSystem authenticationSystem;
    public static final Reflections reflector;
    public static ConfigContainer config;

    public static void main(String[] args2) throws Exception {
        Crypto.loadKeys();
        boolean exitEarly = false;
        block10: for (String arg : args2) {
            switch (arg.toLowerCase()) {
                case "-handbook": {
                    Tools.createGmHandbook();
                    exitEarly = true;
                    continue block10;
                }
                case "-gachamap": {
                    Tools.createGachaMapping(Configuration.DATA("gacha_mappings.js"));
                    exitEarly = true;
                    continue block10;
                }
                case "-version": {
                    System.out.println("Grasscutter version: 1.1.2-dev-82775b4");
                    exitEarly = true;
                }
            }
        }
        if (exitEarly) {
            System.exit(0);
        }
        Grasscutter.getLogger().info(Language.translate("messages.status.starting", new Object[0]));
        Grasscutter.updateDayOfWeek();
        ResourceLoader.loadAll();
        ScriptLoader.init();
        DatabaseManager.initialize();
        authenticationSystem = new DefaultAuthentication();
        httpServer = new HttpServer();
        gameServer = new GameServer();
        new ServerHook(gameServer, httpServer);
        pluginManager = new PluginManager();
        httpServer.addRouter(HttpServer.UnhandledRequestRouter.class, new Object[0]);
        httpServer.addRouter(HttpServer.DefaultRequestRouter.class, new Object[0]);
        httpServer.addRouter(RegionHandler.class, new Object[0]);
        httpServer.addRouter(LogHandler.class, new Object[0]);
        httpServer.addRouter(GenericHandler.class, new Object[0]);
        httpServer.addRouter(AnnouncementsHandler.class, new Object[0]);
        httpServer.addRouter(DispatchHandler.class, new Object[0]);
        httpServer.addRouter(GachaHandler.class, new Object[0]);
        StaminaManager.initialize();
        ServerRunMode runMode = Configuration.SERVER.runMode;
        if (runMode == ServerRunMode.HYBRID) {
            httpServer.start();
            gameServer.start();
        } else if (runMode == ServerRunMode.DISPATCH_ONLY) {
            httpServer.start();
        } else if (runMode == ServerRunMode.GAME_ONLY) {
            gameServer.start();
        } else {
            Grasscutter.getLogger().error(Language.translate("messages.status.run_mode_error", new Object[]{runMode}));
            Grasscutter.getLogger().error(Language.translate("messages.status.run_mode_help", new Object[0]));
            Grasscutter.getLogger().error(Language.translate("messages.status.shutdown", new Object[0]));
            System.exit(1);
        }
        pluginManager.enablePlugins();
        Runtime.getRuntime().addShutdownHook(new Thread(Grasscutter::onShutdown));
        Grasscutter.startConsole();
    }

    private static void onShutdown() {
        pluginManager.disablePlugins();
    }

    public static void loadLanguage() {
        Locale locale = Grasscutter.config.language.language;
        language = Language.getLanguage(Utils.getLanguageCode(locale));
    }

    public static void loadConfig() {
        if (!configFile.exists()) {
            Grasscutter.getLogger().info("config.json could not be found. Generating a default configuration ...");
            config = new ConfigContainer();
            Grasscutter.saveConfig(config);
            return;
        }
        try (FileReader file = new FileReader(configFile);){
            config = gson.fromJson((Reader)file, ConfigContainer.class);
        }
        catch (Exception exception) {
            Grasscutter.getLogger().error("There was an error while trying to load the configuration from config.json. Please make sure that there are no syntax errors. If you want to start with a default configuration, delete your existing config.json.");
            System.exit(1);
        }
    }

    public static void saveConfig(@Nullable ConfigContainer config) {
        if (config == null) {
            config = new ConfigContainer();
        }
        try (FileWriter file = new FileWriter(configFile);){
            file.write(gson.toJson(config));
        }
        catch (IOException ignored) {
            Grasscutter.getLogger().error("Unable to write to config file.");
        }
        catch (Exception e) {
            Grasscutter.getLogger().error("Unable to save config file.", e);
        }
    }

    public static ConfigContainer getConfig() {
        return config;
    }

    public static Language getLanguage() {
        return language;
    }

    public static void setLanguage(Language language) {
        Grasscutter.language = language;
    }

    public static Language getLanguage(String langCode) {
        return Language.getLanguage(langCode);
    }

    public static Logger getLogger() {
        return log;
    }

    public static LineReader getConsole() {
        if (consoleLineReader == null) {
            Terminal terminal = null;
            try {
                terminal = TerminalBuilder.builder().jna(true).build();
            }
            catch (Exception e) {
                try {
                    terminal = TerminalBuilder.builder().dumb(true).build();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            consoleLineReader = LineReaderBuilder.builder().terminal(terminal).build();
        }
        return consoleLineReader;
    }

    public static Gson getGsonFactory() {
        return gson;
    }

    public static HttpServer getHttpServer() {
        return httpServer;
    }

    public static GameServer getGameServer() {
        return gameServer;
    }

    public static PluginManager getPluginManager() {
        return pluginManager;
    }

    public static AuthenticationSystem getAuthenticationSystem() {
        return authenticationSystem;
    }

    public static int getCurrentDayOfWeek() {
        return day;
    }

    public static void updateDayOfWeek() {
        Calendar calendar = Calendar.getInstance();
        day = calendar.get(7);
    }

    public static void startConsole() {
        if (Configuration.SERVER.runMode == ServerRunMode.DISPATCH_ONLY) {
            Grasscutter.getLogger().info(Language.translate("messages.dispatch.no_commands_error", new Object[0]));
            return;
        }
        Grasscutter.getLogger().info(Language.translate("messages.status.done", new Object[0]));
        String input = null;
        boolean isLastInterrupted = false;
        while (true) {
            try {
                input = consoleLineReader.readLine("> ");
            }
            catch (UserInterruptException e) {
                if (!isLastInterrupted) {
                    isLastInterrupted = true;
                    Grasscutter.getLogger().info("Press Ctrl-C again to shutdown.");
                    continue;
                }
                Runtime.getRuntime().exit(0);
            }
            catch (EndOfFileException e) {
                Grasscutter.getLogger().info("EOF detected.");
                continue;
            }
            catch (IOError e) {
                Grasscutter.getLogger().error("An IO error occurred.", e);
                continue;
            }
            isLastInterrupted = false;
            try {
                CommandMap.getInstance().invoke(null, null, input);
                continue;
            }
            catch (Exception e) {
                Grasscutter.getLogger().error(Language.translate("messages.game.command_error", new Object[0]), e);
                continue;
            }
            break;
        }
    }

    public static void setAuthenticationSystem(AuthenticationSystem authenticationSystem) {
        Grasscutter.authenticationSystem = authenticationSystem;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
        configFile = new File("./config.json");
        reflector = new Reflections("emu.grasscutter", new Scanner[0]);
        System.setProperty("logback.configurationFile", "src/main/resources/logback.xml");
        Grasscutter.loadConfig();
        ConfigContainer.updateConfig();
        Grasscutter.loadLanguage();
        Utils.startupCheck();
    }

    public static enum ServerRunMode {
        HYBRID,
        DISPATCH_ONLY,
        GAME_ONLY;

    }

    public static enum ServerDebugMode {
        ALL,
        MISSING,
        NONE;

    }
}

